return {
	"neovim/nvim-lspconfig",
	config = function()
		local lspconfig = require("lspconfig")

		local on_attach = function(_, bufnr)
			-- for MiniCompletion
			vim.o.omnifunc = "v:lua.MiniCompletion.completefunc_lsp"
		end

		local capabilities = vim.lsp.protocol.make_client_capabilities()
		capabilities.textDocument.completion.completionItem.snippetSupport = true
		lspconfig.emmet_ls.setup({
			capabilities = capabilities,
			filetypes = { "css", "html", "javascript" },
		})
	end,
}
