import scala.concurrent.Future

object Repro {
  trait ApiError
  trait AuthInput
  trait AuthOutput
  trait AuthenticatedRequestContext
  trait ObjectId
  trait Output

  type AuthenticatedEndpoint =
    PartialServerEndpointWithSecurityOutput[
      AuthInput,
      AuthenticatedRequestContext,
      Unit,
      ApiError,
      AuthOutput,
      Unit,
      Any,
      Future
    ]

  class BaseEndpoints {
    val authenticatedEndpoint: AuthenticatedEndpoint = ???
  }

  class Endpoints(val baseEndpoints: BaseEndpoints) extends Tapir {
    def jsonBody[T]: EndpointIO[String] = ???

    trait Foo
    trait Tag[T]

    // Type annotation based on compiler outputs using -Xprint:typer
    val baseEndpointWithIntersection
        : Endpoints.this.baseEndpoints.authenticatedEndpoint.EndpointType[
          AuthInput,
          ObjectId & Foo,
          ApiError,
          Unit,
          Any
        ] = baseEndpoints.authenticatedEndpoint.in(path[ObjectId & Foo]("arg"))

    // Type annotation based on compiler outputs using -Xprint:typer
    val baseEndpointNoIntersection: Endpoints.this.baseEndpoints.authenticatedEndpoint.EndpointType[
      AuthInput,
      (ObjectId, Foo),
      ApiError,
      Unit,
      Any
    ] = baseEndpoints.authenticatedEndpoint.in(path[(ObjectId, Foo)]("arg"))

    def queryString: EndpointInput[String] = ???
    def queryMaybeString: EndpointInput[Option[String]] = ???

    // Takes ~130ms - initial object to enforce classloading so the later measurments can be more
    object T0 {
      val groupCalendarNoLogic =
        baseEndpoints.authenticatedEndpoint
          .in("calendar")
          .in(queryString.and(queryMaybeString))
          .get
          .out(jsonBody[Output])
    }

    // Takes ~260 ms
    object T1 {
      val groupCalendarNoLogic =
        baseEndpointWithIntersection
          .in("calendar")
          .in(queryString.and(queryMaybeString))
          .get
          .out(jsonBody[Output])
    }

    // Takes 34ms
    object T2 {
      val groupCalendarNoLogic =
        baseEndpointNoIntersection
          .in("calendar")
          .in(queryString.and(queryMaybeString))
          .get
          .out(jsonBody[Output])
    }
    // Same as T1, take ~140ms, faster due to caching in compiler + JVM warmup
    object T1Bis {
      val groupCalendarNoLogic =
        baseEndpointWithIntersection
          .in("calendar")
          .in(queryString.and(queryMaybeString))
          .get
          .out(jsonBody[Output])
    }
    // Same as T2, takes ~18ms
    object T2Bis {
      val groupCalendarNoLogic =
        baseEndpointNoIntersection
          .in("calendar")
          .in(queryString.and(queryMaybeString))
          .get
          .out(jsonBody[Output])
    }
  }
}
