use core::primitives::*;
use core::io::*;

use operations::scope::ScopeStack;

/// Populates the given scope with all declarations that
/// should be available in every module at the top level
/// (known as the Prelude)
pub fn populate_scope(scope: &mut ScopeStack) {
    // Taking advantage of the scope system to simulate modules
    // This will be replaced with something better in:
    // https://github.com/brain-lang/brain/issues/37
    scope.push_scope();

    stdio::populate_scope(scope);

    boolean::populate_scope(scope);
    u8::populate_scope(scope);

    array::populate_scope(scope);
}
