package net.mocanu.mybatis_bug;

import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface PersonMapper {

    @Insert(
            "insert into person(name, age) values (#{name}, #{age})" +
            "returning id"
    )
    long insert(
            @Param("name") String name,
            @Param("age") Integer age
    );

    @Select("select name from person where id=#{id}")
    PersonWithoutId getById(
            @Param("id") long id
    );

}
