package net.mocanu.mybatis_bug;

import javax.sql.DataSource;
import lombok.NonNull;
import lombok.SneakyThrows;
import org.apache.ibatis.session.Configuration;
import org.mybatis.spring.SqlSessionFactoryBean;

public final class DbSupport {

    private DbSupport() {}

    @SneakyThrows
    public static @NonNull SqlSessionFactoryBean createSqlSessionFactoryBean(
            final @NonNull DataSource dataSource
    ) {
        final SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();

        factoryBean.setDataSource(dataSource);

        final Configuration configuration = new Configuration();
        configuration.setReturnInstanceForEmptyRow(true);
        configuration.addMapper(PersonMapper.class);

        factoryBean.setConfiguration(configuration);

        return factoryBean;
    }

}
