package net.mocanu.mybatis_bug;

import lombok.SneakyThrows;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class App {

    @SneakyThrows
    public static void main(String[] args) {
        final SqlSessionFactoryBean sqlSessionFactoryBean = DbSupport.createSqlSessionFactoryBean(
                new DriverManagerDataSource(
                        "jdbc:postgresql://127.0.0.1:5432/db",
                        "user",
                        "pass"
                )
        );
        final SqlSessionFactory sqlSessionFactory = sqlSessionFactoryBean.getObject();

        try (final SqlSession session = sqlSessionFactory.openSession()) {
            final PersonMapper personMapper = session.getMapper(PersonMapper.class);

            final long personId = personMapper.insert(null, null);

            final PersonWithoutId personWithoutId = personMapper.getById(personId);
            if (personWithoutId == null && session.getConfiguration().isReturnInstanceForEmptyRow()) {
                throw new RuntimeException("got null row because all columns are null, even though `returnInstanceForEmptyRow` is true");
            } else {
                System.out.println("ALL OK");
            }
        }

    }
}
