﻿using AutoFixture;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;

namespace EfComplexPropertyFromSqlTests;

public class DoThis(ILogger<DoThis> logger, IServiceProvider services) : BackgroundService
{
    protected override async Task ExecuteAsync(CancellationToken stoppingToken)
    {
        using var scope = services.CreateScope();
        var db = scope.ServiceProvider.GetRequiredService<Db>();

        logger.LogInformation("Running...");

        await db.Database.MigrateAsync(cancellationToken: stoppingToken);

        await db.Entities.ExecuteDeleteAsync(cancellationToken: stoppingToken);
        db.AddRange(new Fixture()
                    .CreateMany<Entity>(2)
                    .Take(5)
                    .ToList());

        await db.Entities2.ExecuteDeleteAsync(cancellationToken: stoppingToken);
        db.AddRange(new Fixture()
                    .CreateMany<Entity2>(2)
                    .Take(5)
                    .ToList());
        await db.SaveChangesAsync(stoppingToken);

        await Log("Entities2.FromSql",
            db.Entities2.FromSql($"""SELECT * FROM Entities2""")
              .Select(e => new { Entity2Id = e.Id, e.Address }));

        await Log("Entities.Select",
            db.Entities.Select(e => new { EntityId = e.Id, Address = e.ComplexProperty }));

        await Log("Entities.FromSql",
            db.Entities.FromSql($"""SELECT * FROM Entities""")
              .Select(e => new { EntityId = e.Id, Address = e.ComplexProperty }));

        logger.LogInformation("Ran!");
    }

    private async Task Log<T>(string name, IQueryable<T> queryable)
    {
        var result = await queryable.ToListAsync();

        logger.LogInformation("################# RESULT {query} #################", name);
        foreach (var e in result)
            logger.LogInformation("ITEM: {item}", e);

        logger.LogInformation("################# /RESULT {query} #################", name);
    }
}