import json
from aws_lambda_powertools.utilities.data_classes import DynamoDBStreamEvent, event_source
from aws_lambda_powertools.utilities.data_classes.dynamo_db_stream_event import DynamoDBRecordEventName
from boto3.dynamodb.types import TypeDeserializer
deserializer = TypeDeserializer()

@event_source(data_class=DynamoDBStreamEvent)
def handler(event: DynamoDBStreamEvent, context):
    for record in event.records:
        if record.event_name == DynamoDBRecordEventName.REMOVE and record.dynamodb._data.get('OldImage'):
            try:
                output = {k: deserializer.deserialize(v) for k, v in record.dynamodb.old_image.items()}
                print(output)
            except Exception as e:
                print("Fails with Object", e)
            
            from_dict = {k: deserializer.deserialize(v) for k, v in record.dynamodb._data["OldImage"].items()}
            print("Works with Dict", from_dict)


data = json.load(open('ddb_event.json'))
handler(data, {})