/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core.scheduler;

import cn.myperf4j.base.Scheduler;
import cn.myperf4j.base.metric.JvmBufferPoolMetrics;
import cn.myperf4j.base.metric.JvmClassMetrics;
import cn.myperf4j.base.metric.JvmCompilationMetrics;
import cn.myperf4j.base.metric.JvmFileDescriptorMetrics;
import cn.myperf4j.base.metric.JvmGcMetrics;
import cn.myperf4j.base.metric.JvmGcMetricsV3;
import cn.myperf4j.base.metric.JvmMemoryMetrics;
import cn.myperf4j.base.metric.JvmThreadMetrics;
import cn.myperf4j.base.metric.Metrics;
import cn.myperf4j.base.metric.collector.JvmBufferPoolCollector;
import cn.myperf4j.base.metric.collector.JvmClassCollector;
import cn.myperf4j.base.metric.collector.JvmCompilationCollector;
import cn.myperf4j.base.metric.collector.JvmFileDescCollector;
import cn.myperf4j.base.metric.collector.JvmGcCollector;
import cn.myperf4j.base.metric.collector.JvmGcV3Collector;
import cn.myperf4j.base.metric.collector.JvmMemoryCollector;
import cn.myperf4j.base.metric.collector.JvmThreadCollector;
import cn.myperf4j.base.metric.exporter.JvmBufferPoolMetricsExporter;
import cn.myperf4j.base.metric.exporter.JvmClassMetricsExporter;
import cn.myperf4j.base.metric.exporter.JvmCompilationMetricsExporter;
import cn.myperf4j.base.metric.exporter.JvmFileDescMetricsExporter;
import cn.myperf4j.base.metric.exporter.JvmGcMetricsExporter;
import cn.myperf4j.base.metric.exporter.JvmGcMetricsV3Exporter;
import cn.myperf4j.base.metric.exporter.JvmMemoryMetricsExporter;
import cn.myperf4j.base.metric.exporter.JvmThreadMetricsExporter;
import cn.myperf4j.base.util.Logger;
import java.util.List;

public class JvmMetricsScheduler
implements Scheduler {
    private final JvmClassMetricsExporter classMetricsProcessor;
    private final JvmGcMetricsExporter gcMetricsProcessor;
    private final JvmGcMetricsV3Exporter gcMetricsV2Processor;
    private final JvmMemoryMetricsExporter memoryMetricsProcessor;
    private final JvmBufferPoolMetricsExporter bufferPoolMetricsProcessor;
    private final JvmThreadMetricsExporter threadMetricsProcessor;
    private final JvmCompilationMetricsExporter compilationProcessor;
    private final JvmFileDescMetricsExporter fileDescProcessor;

    public JvmMetricsScheduler(JvmClassMetricsExporter classMetricsProcessor, JvmGcMetricsExporter gcMetricsProcessor, JvmGcMetricsV3Exporter gcMetricsV2Processor, JvmMemoryMetricsExporter memoryMetricsProcessor, JvmBufferPoolMetricsExporter bufferPoolMetricsProcessor, JvmThreadMetricsExporter threadMetricsProcessor, JvmCompilationMetricsExporter compilationProcessor, JvmFileDescMetricsExporter fileDescProcessor) {
        this.classMetricsProcessor = classMetricsProcessor;
        this.gcMetricsProcessor = gcMetricsProcessor;
        this.gcMetricsV2Processor = gcMetricsV2Processor;
        this.memoryMetricsProcessor = memoryMetricsProcessor;
        this.bufferPoolMetricsProcessor = bufferPoolMetricsProcessor;
        this.threadMetricsProcessor = threadMetricsProcessor;
        this.compilationProcessor = compilationProcessor;
        this.fileDescProcessor = fileDescProcessor;
    }

    @Override
    public void run(long lastTimeSliceStartTime, long millTimeSlice) {
        long stopMillis = lastTimeSliceStartTime + millTimeSlice;
        this.processClassMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processGCMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processGCMetricsV2(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processMemoryMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processBufferPoolMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processThreadMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processCompilationMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
        this.processFileDescMetrics(lastTimeSliceStartTime, lastTimeSliceStartTime, stopMillis);
    }

    @Override
    public String name() {
        return "JvmMetricsCollector";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassMetrics(long processId, long startMillis, long stopMillis) {
        this.classMetricsProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            JvmClassMetrics metrics = JvmClassCollector.collectClassMetrics();
            this.classMetricsProcessor.process(metrics, processId, startMillis, stopMillis);
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processClassMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.classMetricsProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGCMetrics(long processId, long startMillis, long stopMillis) {
        this.gcMetricsProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            JvmGcMetrics metrics = JvmGcCollector.collectGcMetrics();
            this.gcMetricsProcessor.process(metrics, processId, startMillis, stopMillis);
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processGCMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.gcMetricsProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGCMetricsV2(long processId, long startMillis, long stopMillis) {
        this.gcMetricsV2Processor.beforeProcess(processId, startMillis, stopMillis);
        try {
            List<JvmGcMetricsV3> metricsList = JvmGcV3Collector.collectGcMetrics();
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.gcMetricsV2Processor.process((Metrics)metricsList.get(i), processId, startMillis, stopMillis);
            }
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processGCMetricsV2(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.gcMetricsV2Processor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemoryMetrics(long processId, long startMillis, long stopMillis) {
        this.memoryMetricsProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            JvmMemoryMetrics metrics = JvmMemoryCollector.collectMemoryMetrics();
            this.memoryMetricsProcessor.process(metrics, processId, startMillis, stopMillis);
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processMemoryMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.memoryMetricsProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBufferPoolMetrics(long processId, long startMillis, long stopMillis) {
        this.bufferPoolMetricsProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            List<JvmBufferPoolMetrics> metricsList = JvmBufferPoolCollector.collectBufferPoolMetrics();
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.bufferPoolMetricsProcessor.process((Metrics)metricsList.get(i), processId, startMillis, stopMillis);
            }
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processBufferPoolMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.bufferPoolMetricsProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadMetrics(long processId, long startMillis, long stopMillis) {
        this.threadMetricsProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            JvmThreadMetrics metrics = JvmThreadCollector.collectThreadMetrics();
            this.threadMetricsProcessor.process(metrics, processId, startMillis, stopMillis);
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processThreadMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.threadMetricsProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompilationMetrics(long processId, long startMillis, long stopMillis) {
        this.compilationProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            JvmCompilationMetrics metrics = JvmCompilationCollector.collectCompilationMetrics();
            this.compilationProcessor.process(metrics, processId, startMillis, stopMillis);
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processCompilationMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.compilationProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFileDescMetrics(long processId, long startMillis, long stopMillis) {
        this.fileDescProcessor.beforeProcess(processId, startMillis, stopMillis);
        try {
            JvmFileDescriptorMetrics metrics = JvmFileDescCollector.collectFileDescMetrics();
            this.fileDescProcessor.process(metrics, processId, startMillis, stopMillis);
        }
        catch (Throwable t) {
            Logger.error("JvmMetricsScheduler.processFileDescMetrics(" + processId + ", " + startMillis + ", " + stopMillis + ")", t);
        }
        finally {
            this.fileDescProcessor.afterProcess(processId, startMillis, stopMillis);
        }
    }
}

