/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core.recorder;

import cn.myperf4j.core.recorder.Recorder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Recorders {
    private final AtomicReferenceArray<Recorder> recorderArr;
    private final AtomicInteger recorderCount;
    private volatile boolean writing;
    private volatile long startTime;
    private volatile long stopTime;

    public Recorders(AtomicReferenceArray<Recorder> recorderArr) {
        this.recorderArr = recorderArr;
        this.recorderCount = new AtomicInteger(0);
    }

    public Recorder getRecorder(int index) {
        return this.recorderArr.get(index);
    }

    public void setRecorder(int index, Recorder recorder) {
        this.recorderArr.set(index, recorder);
        this.recorderCount.incrementAndGet();
    }

    public int size() {
        return this.recorderArr.length();
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public void resetRecorder() {
        int count = this.recorderCount.get();
        AtomicReferenceArray<Recorder> recorderArr = this.recorderArr;
        for (int i = 0; i < count; ++i) {
            Recorder recorder = recorderArr.get(i);
            if (recorder == null) continue;
            recorder.resetRecord();
        }
    }

    public String toString() {
        return "Recorders{recorderArr=" + this.recorderArr + ", writing=" + this.writing + ", startTime=" + this.startTime + ", stopTime=" + this.stopTime + '}';
    }
}

