/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core.recorder;

import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.Scheduler;
import cn.myperf4j.base.config.ProfilingParams;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.metric.MethodMetrics;
import cn.myperf4j.base.metric.exporter.MethodMetricsExporter;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.concurrent.ExecutorManager;
import cn.myperf4j.base.util.concurrent.ThreadUtils;
import cn.myperf4j.core.MethodMetricsCalculator;
import cn.myperf4j.core.MethodMetricsHistogram;
import cn.myperf4j.core.MethodTagMaintainer;
import cn.myperf4j.core.recorder.DefaultRecorder;
import cn.myperf4j.core.recorder.Recorder;
import cn.myperf4j.core.recorder.Recorders;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class AbstractRecorderMaintainer
implements Scheduler {
    private static final int MAX_DELAY_TASKS = 1024;
    private volatile boolean initialState;
    protected List<Recorders> recordersList;
    private int curIndex;
    private volatile Recorders curRecorders;
    private ScheduledThreadPoolExecutor backgroundExecutor;
    private MethodMetricsExporter methodMetricsExporter;

    public boolean initial(MethodMetricsExporter processor, int bakRecordersCnt) {
        this.methodMetricsExporter = processor;
        if (!this.initRecorders(this.getFitBakRecordersCnt(bakRecordersCnt)) || !this.initBackgroundTask()) {
            return false;
        }
        this.initialState = this.initOther();
        return this.initialState;
    }

    private int getFitBakRecordersCnt(int backupRecordersCount) {
        if (backupRecordersCount < 1) {
            return 1;
        }
        if (backupRecordersCount > 8) {
            return 8;
        }
        return backupRecordersCount;
    }

    private boolean initRecorders(int backupRecordersCount) {
        this.recordersList = new ArrayList<Recorders>(backupRecordersCount + 1);
        for (int i = 0; i < backupRecordersCount + 1; ++i) {
            this.recordersList.add(new Recorders(new AtomicReferenceArray<Recorder>(32768)));
        }
        this.curRecorders = this.recordersList.get(this.curIndex);
        return true;
    }

    private boolean initBackgroundTask() {
        try {
            this.backgroundExecutor = new ScheduledThreadPoolExecutor(1, ThreadUtils.newThreadFactory("MyPerf4J-BackgroundExecutor_"), new ThreadPoolExecutor.DiscardOldestPolicy());
            ExecutorManager.addExecutorService(this.backgroundExecutor);
            return true;
        }
        catch (Exception e) {
            Logger.error("RecorderMaintainer.initBackgroundTask()", e);
            return false;
        }
    }

    public abstract boolean initOther();

    protected Recorder createRecorder(int methodTagId, ProfilingParams params) {
        return DefaultRecorder.getInstance(methodTagId, params.mostTimeThreshold(), params.outThresholdCount());
    }

    public abstract void addRecorder(int var1, ProfilingParams var2);

    public Recorder getRecorder(int methodTagId) {
        return this.curRecorders.getRecorder(methodTagId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(long lastTimeSliceStartTime, long millTimeSlice) {
        try {
            if (!this.initialState) {
                Logger.warn("AbstractRecorderMaintainer.run(long, long): initialState is false!");
                return;
            }
            Recorders lastRecorders = this.turnAroundRecorders(lastTimeSliceStartTime, millTimeSlice);
            this.backgroundExecutor.schedule(new ExportMetricsTask(this.methodMetricsExporter, lastRecorders), 10L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Logger.error("RecorderMaintainer.run(long, long) error", e);
        }
        finally {
            this.tryDiscardDelayTask();
        }
    }

    private Recorders turnAroundRecorders(long lastTimeSliceStartTime, long millTimeSlice) {
        Recorders lastRecorders = this.curRecorders;
        lastRecorders.setStartTime(lastTimeSliceStartTime);
        lastRecorders.setStopTime(lastTimeSliceStartTime + millTimeSlice);
        lastRecorders.setWriting(false);
        this.curRecorders = this.nextRecorders(lastTimeSliceStartTime, millTimeSlice);
        return lastRecorders;
    }

    private Recorders nextRecorders(long lastTimeSliceStartTime, long millTimeSlice) {
        this.curIndex = this.getNextIdx(this.curIndex, this.recordersList.size());
        Logger.debug("RecorderMaintainer.nextRecorders(long, long) curIndex=" + this.curIndex);
        Recorders nextRecorders = this.recordersList.get(this.curIndex);
        nextRecorders.setStartTime(lastTimeSliceStartTime + millTimeSlice);
        nextRecorders.setStopTime(lastTimeSliceStartTime + 2L * millTimeSlice);
        nextRecorders.setWriting(true);
        nextRecorders.resetRecorder();
        return nextRecorders;
    }

    private int getNextIdx(int idx, int maxIdx) {
        return (idx + 1) % maxIdx;
    }

    private void tryDiscardDelayTask() {
        BlockingQueue<Runnable> queue = this.backgroundExecutor.getQueue();
        if (queue.size() >= 1024) {
            queue.poll();
            Logger.warn("RecorderMaintainer.tryDiscardDelayTask the backgroundExecutor delay task count reach 1024, so discard oldest one!");
        }
    }

    @Override
    public String name() {
        return "RecorderMaintainer";
    }

    private static final class ExportMetricsTask
    implements Runnable {
        private final MethodTagMaintainer methodTagMaintainer = MethodTagMaintainer.getInstance();
        private final MethodMetricsExporter metricsExporter;
        private final Recorders lastRecorders;

        private ExportMetricsTask(MethodMetricsExporter metricsExporter, Recorders lastRecorders) {
            this.metricsExporter = metricsExporter;
            this.lastRecorders = lastRecorders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.lastRecorders.isWriting()) {
                Logger.warn("ExportMetricsTask.run() the lastRecorders is writing! Please increase `" + PropertyKeys.Metrics.TIME_SLICE_METHOD + "` or `" + PropertyKeys.Recorder.BACKUP_COUNT + "`!P1");
                return;
            }
            long start = System.currentTimeMillis();
            long epochStartMillis = this.lastRecorders.getStartTime();
            long epochEndMillis = this.lastRecorders.getStopTime();
            try {
                this.metricsExporter.beforeProcess(epochStartMillis, epochStartMillis, epochEndMillis);
                int actualSize = this.methodTagMaintainer.getMethodTagCount();
                for (int i = 0; i < actualSize; ++i) {
                    if (this.lastRecorders.isWriting()) {
                        Logger.warn("ExportMetricsTask.run() the lastRecorders is writing! Please increase `" + PropertyKeys.Metrics.TIME_SLICE_METHOD + "` or `" + PropertyKeys.Recorder.BACKUP_COUNT + "`!P2");
                        break;
                    }
                    Recorder recorder = this.lastRecorders.getRecorder(i);
                    if (recorder == null) continue;
                    if (!recorder.hasRecord()) {
                        MethodMetricsHistogram.recordNoneMetrics(recorder.getMethodTagId());
                        continue;
                    }
                    MethodTag methodTag = this.methodTagMaintainer.getMethodTag(recorder.getMethodTagId());
                    MethodMetrics metrics = MethodMetricsCalculator.calMetrics(recorder, methodTag, epochStartMillis, epochEndMillis);
                    MethodMetricsHistogram.recordMetrics(metrics);
                    this.metricsExporter.process(metrics, epochStartMillis, epochStartMillis, epochEndMillis);
                }
            }
            catch (Throwable t) {
                Logger.error("ExportMetricsTask.run() error", t);
            }
            finally {
                this.metricsExporter.afterProcess(epochStartMillis, epochStartMillis, epochEndMillis);
                long cost = System.currentTimeMillis() - start;
                Logger.debug("ExportMetricsTask.run() finished!!! cost: " + cost + "ms");
            }
        }
    }
}

