/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core;

import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.config.MetricsConfig;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.TypeDescUtils;
import cn.myperf4j.core.AbstractMethodTagMaintainer;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class MethodTagMaintainer
extends AbstractMethodTagMaintainer {
    public static final int MAX_NUM = 32768;
    private static final MethodTagMaintainer instance = new MethodTagMaintainer();
    private static final MetricsConfig metricsConfig = ProfilingConfig.metricsConfig();
    private final AtomicInteger index = new AtomicInteger(0);
    private final AtomicReferenceArray<MethodTag> methodTagArr = new AtomicReferenceArray(32768);
    private final ConcurrentHashMap<Method, Integer> methodMap = new ConcurrentHashMap(4096);

    public static MethodTagMaintainer getInstance() {
        return instance;
    }

    private MethodTagMaintainer() {
    }

    @Override
    public int addMethodTag(MethodTag methodTag) {
        int methodId = this.index.getAndIncrement();
        if (methodId > 32768) {
            Logger.warn("MethodTagMaintainer.addMethodTag(" + methodTag + "): methodId > MAX_NUM: " + methodId + " > " + 32768 + ", ignored!!!");
            return -1;
        }
        this.methodTagArr.set(methodId, methodTag);
        return methodId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addMethodTag(Method method) {
        Integer tagId = this.methodMap.get(method);
        if (tagId != null) {
            return tagId;
        }
        MethodTagMaintainer methodTagMaintainer = this;
        synchronized (methodTagMaintainer) {
            tagId = this.methodMap.get(method);
            if (tagId != null) {
                return tagId;
            }
            tagId = this.addMethodTag(MethodTagMaintainer.createMethodTag(method));
        }
        if (tagId < 0) {
            return tagId;
        }
        this.methodMap.putIfAbsent(method, tagId);
        return tagId;
    }

    private static MethodTag createMethodTag(Method method) {
        String methodParamDesc = metricsConfig.showMethodParams() ? TypeDescUtils.getMethodParamsDesc(method) : "";
        Class<?> declaringClass = method.getDeclaringClass();
        return MethodTag.getDynamicProxyInstance(declaringClass.getName(), declaringClass.getSimpleName(), method.getName(), methodParamDesc);
    }

    @Override
    public MethodTag getMethodTag(int methodId) {
        if (methodId >= 0 && methodId < 32768) {
            return this.methodTagArr.get(methodId);
        }
        return null;
    }

    @Override
    public int getMethodTagCount() {
        return this.index.get();
    }
}

