/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core;

import cn.myperf4j.base.Scheduler;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.concurrent.ExecutorManager;
import cn.myperf4j.base.util.concurrent.ThreadUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class LightWeightScheduler {
    private static final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(2, ThreadUtils.newThreadFactory("MyPerf4J-LightWeightScheduler-"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final List<Scheduler> schedulerList;
    private final long initialDelay;
    private final long period;
    private final TimeUnit unit;
    private final long millTimeSlice;
    private volatile long nextTimeSliceEndTime;

    private LightWeightScheduler(List<Scheduler> schedulerList, long initialDelay, long period, TimeUnit unit, long millTimeSlice) {
        this.schedulerList = Collections.unmodifiableList(schedulerList);
        this.millTimeSlice = millTimeSlice;
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
    }

    public static void dispatchScheduleTask(Scheduler scheduler, long millTimeSlice) {
        LightWeightScheduler.dispatchScheduleTask(Collections.singletonList(scheduler), millTimeSlice);
    }

    public static void dispatchScheduleTask(List<Scheduler> schedulerList, long millTimeSlice) {
        millTimeSlice = LightWeightScheduler.getFitMillTimeSlice(millTimeSlice);
        new LightWeightScheduler(schedulerList, 0L, 10L, TimeUnit.MILLISECONDS, millTimeSlice).start();
    }

    private static long getFitMillTimeSlice(long millTimeSlice) {
        if (millTimeSlice < 1000L) {
            return 1000L;
        }
        if (millTimeSlice > 600000L) {
            return 600000L;
        }
        return millTimeSlice;
    }

    private void start() {
        scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long currentMills = System.currentTimeMillis();
                if (LightWeightScheduler.this.nextTimeSliceEndTime == 0L) {
                    LightWeightScheduler.this.nextTimeSliceEndTime = currentMills / LightWeightScheduler.this.millTimeSlice * LightWeightScheduler.this.millTimeSlice + LightWeightScheduler.this.millTimeSlice;
                }
                if (LightWeightScheduler.this.nextTimeSliceEndTime > currentMills) {
                    return;
                }
                LightWeightScheduler.this.nextTimeSliceEndTime = currentMills / LightWeightScheduler.this.millTimeSlice * LightWeightScheduler.this.millTimeSlice + LightWeightScheduler.this.millTimeSlice;
                LightWeightScheduler.this.runAllTasks(currentMills);
            }
        }, this.initialDelay, this.period, this.unit);
    }

    private void runAllTasks(long currentMills) {
        long lastTimeSliceStartTime = currentMills - this.millTimeSlice;
        for (int i = 0; i < this.schedulerList.size(); ++i) {
            this.runTask(this.schedulerList.get(i), lastTimeSliceStartTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(Scheduler scheduler, long lastTimeSliceStartTime) {
        long startMills = System.currentTimeMillis();
        try {
            scheduler.run(lastTimeSliceStartTime, this.millTimeSlice);
        }
        catch (Exception e) {
            Logger.error("LightWeightScheduler.runTask(" + scheduler + ", " + lastTimeSliceStartTime + ")", e);
        }
        finally {
            Logger.debug("LightWeightScheduler.runTask(" + scheduler.name() + ", " + lastTimeSliceStartTime + ") cost: " + (System.currentTimeMillis() - startMills) + "ms");
        }
    }

    static {
        ExecutorManager.addExecutorService(scheduledExecutor);
    }
}

