/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.core;

import cn.myperf4j.base.Scheduler;
import cn.myperf4j.base.Version;
import cn.myperf4j.base.config.BasicConfig;
import cn.myperf4j.base.config.FilterConfig;
import cn.myperf4j.base.config.HttpServerConfig;
import cn.myperf4j.base.config.InfluxDbConfig;
import cn.myperf4j.base.config.LevelMappingFilter;
import cn.myperf4j.base.config.MetricsConfig;
import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.config.ProfilingFilter;
import cn.myperf4j.base.config.RecorderConfig;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.http.HttpHeaders;
import cn.myperf4j.base.http.HttpRespStatus;
import cn.myperf4j.base.http.HttpResponse;
import cn.myperf4j.base.http.server.Dispatcher;
import cn.myperf4j.base.http.server.SimpleHttpServer;
import cn.myperf4j.base.metric.exporter.MethodMetricsExporter;
import cn.myperf4j.base.metric.exporter.MetricsExporterFactory;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.NumUtils;
import cn.myperf4j.base.util.StrUtils;
import cn.myperf4j.base.util.SysProperties;
import cn.myperf4j.base.util.concurrent.ExecutorManager;
import cn.myperf4j.base.util.net.NetUtils;
import cn.myperf4j.core.LightWeightScheduler;
import cn.myperf4j.core.MethodMetricsHistogram;
import cn.myperf4j.core.recorder.AbstractRecorderMaintainer;
import cn.myperf4j.core.scheduler.JvmMetricsScheduler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractBootstrap {
    private volatile boolean initStatus;
    protected MethodMetricsExporter methodMetricsExporter;
    protected AbstractRecorderMaintainer maintainer;

    public final boolean initial() {
        try {
            if (this.initStatus) {
                Logger.warn("AbstractBootstrap is already init.");
                return true;
            }
            Logger.info("Thanks sincerely for using MyPerf4J.");
            this.initStatus = this.doInitial();
            if (!this.initStatus) {
                Logger.error("AbstractBootstrap doInitial() FAILURE!!!");
                return false;
            }
            this.printBannerText();
            Logger.info("AbstractBootstrap doInitial() SUCCESS!!!");
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initial()", e);
            return false;
        }
    }

    private boolean doInitial() {
        if (!this.initProperties()) {
            Logger.error("AbstractBootstrap initProperties() FAILURE!!!");
            return false;
        }
        if (!this.initProfilingConfig()) {
            Logger.error("AbstractBootstrap initProfilingConfig() FAILURE!!!");
            return false;
        }
        if (!this.initLogger()) {
            Logger.error("AbstractBootstrap initLogger() FAILURE!!!");
            return false;
        }
        if (!this.initPackageFilter()) {
            Logger.error("AbstractBootstrap initPackageFilter() FAILURE!!!");
            return false;
        }
        if (!this.initClassLoaderFilter()) {
            Logger.error("AbstractBootstrap initClassLoaderFilter() FAILURE!!!");
            return false;
        }
        if (!this.initMethodFilter()) {
            Logger.error("AbstractBootstrap initMethodFilter() FAILURE!!!");
            return false;
        }
        if (!this.initClassLevelMapping()) {
            Logger.error("AbstractBootstrap initClassLevelMapping() FAILURE!!!");
            return false;
        }
        if (!this.initMethodMetricsExporter()) {
            Logger.error("AbstractBootstrap initMethodMetricsExporter() FAILURE!!!");
            return false;
        }
        if (!this.initProfilingParams()) {
            Logger.error("AbstractBootstrap initProfilingParams() FAILURE!!!");
            return false;
        }
        if (!this.initRecorderMaintainer()) {
            Logger.error("AbstractBootstrap initRecorderMaintainer() FAILURE!!!");
            return false;
        }
        if (!this.initShutDownHook()) {
            Logger.error("AbstractBootstrap initShutDownHook() FAILURE!!!");
            return false;
        }
        if (!this.initScheduler()) {
            Logger.error("AbstractBootstrap initScheduler() FAILURE!!!");
            return false;
        }
        if (!this.initHttpServer()) {
            Logger.error("AbstractBootstrap initHttpServer() FAILURE!!!");
            return false;
        }
        if (!this.initOther()) {
            Logger.error("AbstractBootstrap initOther() FAILURE!!!");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initProperties() {
        String configFilePath = System.getProperty("MyPerf4JPropFile", "/data/MyPerf4J/MyPerf4J.properties");
        try (InputStream in = Files.newInputStream(Paths.get(configFilePath, new String[0]), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(in);
            properties.put(PropertyKeys.Basic.PROPERTIES_FILE_DIR.key(), this.parseConfigFileDir(configFilePath));
            boolean bl = MyProperties.initial(properties);
            return bl;
        }
        catch (IOException e) {
            Logger.error("AbstractBootstrap.initProperties()", e);
            return false;
        }
    }

    private String parseConfigFileDir(String configFilePath) {
        int idx = configFilePath.lastIndexOf(File.separatorChar);
        return configFilePath.substring(0, idx + 1);
    }

    private boolean initProfilingConfig() {
        try {
            ProfilingConfig.basicConfig(BasicConfig.loadBasicConfig());
            ProfilingConfig.metricsConfig(MetricsConfig.loadMetricsConfig());
            ProfilingConfig.influxDBConfig(InfluxDbConfig.loadInfluxDbConfig());
            ProfilingConfig.filterConfig(FilterConfig.loadFilterConfig());
            ProfilingConfig.recorderConfig(RecorderConfig.loadRecorderConfig());
            ProfilingConfig.httpServerConfig(HttpServerConfig.loadHttpServerConfig());
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initProfilingConfig()", e);
            return false;
        }
    }

    private boolean initLogger() {
        try {
            Logger.setDebugEnable(ProfilingConfig.basicConfig().debug());
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initLogger()", e);
            return false;
        }
    }

    private boolean initPackageFilter() {
        try {
            FilterConfig filterConfig = ProfilingConfig.filterConfig();
            List<String> includeList = StrUtils.splitAsList(filterConfig.includePackages(), ';');
            includeList.forEach(ProfilingFilter::addIncludePackage);
            List<String> excludeList = StrUtils.splitAsList(filterConfig.excludePackages(), ';');
            excludeList.forEach(ProfilingFilter::addExcludePackage);
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initPackageFilter()", e);
            return false;
        }
    }

    private boolean initClassLoaderFilter() {
        try {
            FilterConfig filterConfig = ProfilingConfig.filterConfig();
            List<String> excludeList = StrUtils.splitAsList(filterConfig.excludeClassLoaders(), ';');
            excludeList.forEach(ProfilingFilter::addExcludeClassLoader);
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initClassLoaderFilter()", e);
            return false;
        }
    }

    private boolean initMethodFilter() {
        try {
            FilterConfig filterConfig = ProfilingConfig.filterConfig();
            List<String> excludeList = StrUtils.splitAsList(filterConfig.excludeMethods(), ';');
            excludeList.forEach(ProfilingFilter::addExcludeMethods);
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initMethodFilter()", e);
            return false;
        }
    }

    private boolean initClassLevelMapping() {
        try {
            MetricsConfig metricsConfig = ProfilingConfig.metricsConfig();
            String levelMappings = metricsConfig.classLevelMapping();
            if (StrUtils.isBlank(levelMappings)) {
                Logger.info("ClassLevelMapping is blank, so use default mappings.");
                return true;
            }
            List<String> mappingPairs = StrUtils.splitAsList(levelMappings, ';');
            for (int i = 0; i < mappingPairs.size(); ++i) {
                String mappingPair = mappingPairs.get(i);
                List<String> pairs = StrUtils.splitAsList(mappingPair, ':');
                if (pairs.size() != 2) {
                    Logger.warn("MethodLevelMapping is not correct: " + mappingPair);
                    continue;
                }
                LevelMappingFilter.putLevelMapping(pairs.get(0), this.getMappingExpList(pairs.get(1)));
            }
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initClassLevelMapping()", e);
            return false;
        }
    }

    private List<String> getMappingExpList(String expStr) {
        expStr = expStr.substring(1, expStr.length() - 1);
        return StrUtils.splitAsList(expStr, ',');
    }

    private boolean initMethodMetricsExporter() {
        try {
            String exporter = ProfilingConfig.metricsConfig().metricsExporter();
            this.methodMetricsExporter = MetricsExporterFactory.getMethodMetricsExporter(exporter);
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initPerfStatsProcessor()", e);
            return false;
        }
    }

    private boolean initProfilingParams() {
        try {
            RecorderConfig recorderConf = ProfilingConfig.recorderConfig();
            BasicConfig basicConfig = ProfilingConfig.basicConfig();
            File sysFile = new File(basicConfig.sysProfilingParamsFile());
            if (sysFile.exists() && sysFile.isFile()) {
                Logger.info("Loading " + sysFile.getName() + " to init profiling params.");
                this.addProfilingParams0(recorderConf, sysFile.getAbsolutePath());
            }
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initProfilingParams()", e);
            return false;
        }
    }

    private void addProfilingParams0(RecorderConfig recorderConf, String profilingParamFile) {
        try (InputStream in = Files.newInputStream(Paths.get(profilingParamFile, new String[0]), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(in);
            Set<String> keys = properties.stringPropertyNames();
            for (String key : keys) {
                List<String> strList;
                String value = properties.getProperty(key);
                if (value == null || (strList = StrUtils.splitAsList(value, ':')).size() != 2) continue;
                int timeThreshold = NumUtils.parseInt(strList.get(0).trim(), 1000);
                int outThresholdCount = NumUtils.parseInt(strList.get(1).trim(), 64);
                recorderConf.addProfilingParam(key.replace('.', '/'), timeThreshold, outThresholdCount);
            }
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.addProfilingParams(" + profilingParamFile + ")", e);
        }
    }

    private boolean initRecorderMaintainer() {
        this.maintainer = this.doInitRecorderMaintainer();
        return this.maintainer != null;
    }

    public abstract AbstractRecorderMaintainer doInitRecorderMaintainer();

    private boolean initShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Logger.info("ENTER ShutdownHook...");
            try {
                ExecutorManager.stopAll(6L, TimeUnit.SECONDS);
            }
            finally {
                Logger.info("EXIT ShutdownHook...");
            }
        }));
        return true;
    }

    private boolean initScheduler() {
        try {
            MetricsConfig config = ProfilingConfig.metricsConfig();
            LightWeightScheduler.dispatchScheduleTask(this.maintainer, config.methodMilliTimeSlice());
            LightWeightScheduler.dispatchScheduleTask(this.buildJvmMetricsScheduler(), config.jvmMilliTimeSlice());
            LightWeightScheduler.dispatchScheduleTask(this.buildSysGenProfilingScheduler(), 60000L);
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initScheduler()", e);
            return false;
        }
    }

    private Scheduler buildJvmMetricsScheduler() {
        String exporter = ProfilingConfig.metricsConfig().metricsExporter();
        return new JvmMetricsScheduler(MetricsExporterFactory.getClassMetricsExporter(exporter), MetricsExporterFactory.getGcMetricsExporter(exporter), MetricsExporterFactory.getGcMetricsV3Exporter(exporter), MetricsExporterFactory.getMemoryMetricsExporter(exporter), MetricsExporterFactory.getBufferPoolMetricsExporter(exporter), MetricsExporterFactory.getThreadMetricsExporter(exporter), MetricsExporterFactory.getCompilationExporter(exporter), MetricsExporterFactory.getFileDescExporter(exporter));
    }

    private Scheduler buildSysGenProfilingScheduler() {
        return new Scheduler(){

            @Override
            public void run(long lastTimeSliceStartTime, long millTimeSlice) {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                if (bean.getUptime() >= 3600000L) {
                    MethodMetricsHistogram.buildSysGenProfilingFile();
                }
            }

            @Override
            public String name() {
                return "ProfilingFileGenerator";
            }
        };
    }

    private boolean initHttpServer() {
        try {
            HttpServerConfig config = ProfilingConfig.httpServerConfig();
            SimpleHttpServer server = new SimpleHttpServer.Builder().port(this.choseHttpServerPort(config)).minWorkers(config.getMinWorkers()).maxWorkers(config.getMaxWorkers()).acceptCnt(config.getAcceptCount()).dispatcher(this.getHttpServerDispatch()).build();
            server.startAsync();
            return true;
        }
        catch (Exception e) {
            Logger.error("AbstractBootstrap.initHttpServer()", e);
            return false;
        }
    }

    private int choseHttpServerPort(HttpServerConfig config) {
        int preferencePort = config.getPreferencePort();
        if (NetUtils.isPortAvailable(preferencePort)) {
            Logger.info("Use " + preferencePort + " as HttpServer port.");
            return preferencePort;
        }
        for (int port = config.getMinPort(); port < config.getMaxPort(); ++port) {
            if (!NetUtils.isPortAvailable(port)) continue;
            Logger.info("Use " + port + " as HttpServer port.");
            return port;
        }
        throw new IllegalStateException("Has no available port for HttpServer!");
    }

    private Dispatcher getHttpServerDispatch() {
        return request -> {
            if (!"/switch/debugMode".equals(request.getPath())) {
                return new HttpResponse(HttpRespStatus.NOT_FOUND, new HttpHeaders(0), "");
            }
            Logger.setDebugEnable(request.getBoolParam("enable"));
            return new HttpResponse(HttpRespStatus.OK, new HttpHeaders(0), "Success");
        };
    }

    public abstract boolean initOther();

    private void printBannerText() {
        Logger.info(SysProperties.LINE_SEPARATOR + "    __  ___      ____            ______ __      __" + SysProperties.LINE_SEPARATOR + "   /  |/  /_  __/ __ \\___  _____/ __/ // /     / /" + SysProperties.LINE_SEPARATOR + "  / /|_/ / / / / /_/ / _ \\/ ___/ /_/ // /___  / / " + SysProperties.LINE_SEPARATOR + " / /  / / /_/ / ____/  __/ /  / __/__  __/ /_/ /  " + SysProperties.LINE_SEPARATOR + "/_/  /_/\\__, /_/    \\___/_/  /_/    /_/  \\____/   " + SysProperties.LINE_SEPARATOR + "       /____/                                     v" + Version.getVersion() + SysProperties.LINE_SEPARATOR);
    }
}

