/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.net;

import cn.myperf4j.base.util.Logger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class IpUtils {
    private static String localIp = "127.0.0.1";
    private static String localHostName = "localhost";

    private static InetAddress getInnerInetAddr() throws UnknownHostException {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress inetAddress = ips.nextElement();
                    if (!IpUtils.isInnerIpv4(inetAddress)) continue;
                    return inetAddress;
                }
            }
        }
        catch (Exception e) {
            Logger.error("IpUtils.getInnerInetAddr(): catch Exception!", e);
        }
        return InetAddress.getLocalHost();
    }

    private static boolean isInnerIpv4(String ipAddr) {
        try {
            return IpUtils.isInnerIpv4(InetAddress.getByName(ipAddr));
        }
        catch (UnknownHostException e) {
            Logger.error("IpUtils.isInnerIpv4(" + ipAddr + ")", e);
            return false;
        }
    }

    private static boolean isInnerIpv4(InetAddress inetAddress) {
        return inetAddress instanceof Inet4Address && inetAddress.isSiteLocalAddress();
    }

    public static String getLocalIp() {
        return localIp;
    }

    public static String getLocalhostName() {
        return localHostName;
    }

    private IpUtils() {
    }

    static {
        try {
            InetAddress innerInetAddr = IpUtils.getInnerInetAddr();
            localIp = innerInetAddr.getHostAddress();
            localHostName = innerInetAddr.getHostName();
            Logger.info("IpUtils:1 localIp=" + localIp + ", localHostName=" + localHostName);
        }
        catch (Throwable t) {
            Logger.error("IpUtils.static1 initializer()", t);
        }
        try {
            InetAddress localInetAddress = InetAddress.getLocalHost();
            if (!IpUtils.isInnerIpv4(localIp)) {
                localIp = localInetAddress.getHostAddress();
                localHostName = localInetAddress.getHostName();
                Logger.info("IpUtils:2 localIp=" + localIp + ", localHostName=" + localHostName);
            } else if (localIp.equals(localHostName)) {
                localHostName = localInetAddress.getHostName();
                Logger.info("IpUtils:3 localIp=" + localIp + ", localHostName=" + localHostName);
            }
        }
        catch (Throwable t) {
            Logger.error("IpUtils.static2 initializer()", t);
        }
    }
}

