/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.concurrent;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.UnsafeUtils;
import cn.myperf4j.base.util.concurrent.AtomicIntArray;
import java.io.Serializable;
import sun.misc.Unsafe;

public final class SimpleAtomicIntArray
implements AtomicIntArray,
Serializable {
    private static final long serialVersionUID = 4512166855752664301L;
    private static final Unsafe unsafe = UnsafeUtils.getUnsafe();
    private static final int base = Unsafe.ARRAY_INT_BASE_OFFSET;
    private static final int scale = Unsafe.ARRAY_INT_INDEX_SCALE;
    private static final int shift = 31 - Integer.numberOfLeadingZeros(scale);
    private final int[] array;

    private long checkedByteOffset(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return SimpleAtomicIntArray.byteOffset(i);
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    public SimpleAtomicIntArray(int length) {
        this.array = new int[length];
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public int get(int index) {
        return this.getRaw(this.checkedByteOffset(index));
    }

    private int getRaw(long offset) {
        return unsafe.getIntVolatile(this.array, offset);
    }

    @Override
    public int getAndIncrement(int index) {
        return this.getAndAdd(index, 1);
    }

    @Override
    public int getAndAdd(int index, int delta) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(index), delta);
    }

    @Override
    public int incrementAndGet(int index) {
        return this.addAndGet(index, 1);
    }

    @Override
    public int addAndGet(int index, int delta) {
        return this.getAndAdd(index, delta) + delta;
    }

    @Override
    public void reset() {
        unsafe.setMemory(this.array, SimpleAtomicIntArray.byteOffset(0), (long)this.array.length * (long)scale, (byte)0);
    }

    @Override
    public long fillSortedKvs(LongBuf longBuf) {
        long totalCount = 0L;
        int len = this.array.length;
        for (int i = 0; i < len; ++i) {
            int count = this.get(i);
            if (count <= 0) continue;
            longBuf.write(i, count);
            totalCount += (long)count;
        }
        return totalCount;
    }

    static {
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
    }
}

