/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.concurrent;

import cn.myperf4j.base.buffer.LongBuf;
import cn.myperf4j.base.util.NumUtils;
import cn.myperf4j.base.util.UnsafeUtils;
import cn.myperf4j.base.util.concurrent.AtomicIntArray;
import java.io.Serializable;
import sun.misc.Unsafe;

public final class FastAtomicIntArray
implements AtomicIntArray,
Serializable {
    private static final long serialVersionUID = -4361761107900070905L;
    private static final Unsafe unsafe = UnsafeUtils.getUnsafe();
    private static final int base = Unsafe.ARRAY_INT_BASE_OFFSET;
    private static final int scale = Unsafe.ARRAY_INT_INDEX_SCALE;
    private static final int shift = 31 - Integer.numberOfLeadingZeros(scale);
    private static final int falseSharingShift = 31 - Integer.numberOfLeadingZeros(64 / scale);
    private final int shards;
    private final int length;
    private final int actualLength;
    private final int[] array;

    public FastAtomicIntArray(int length) {
        this(length, 4);
    }

    public FastAtomicIntArray(int length, int shards) {
        if (!NumUtils.isPowerOfTwo(shards)) {
            throw new IllegalArgumentException("shards not a power of two");
        }
        this.shards = shards;
        this.length = length;
        this.actualLength = length << falseSharingShift + (31 - Integer.numberOfLeadingZeros(shards));
        this.array = new int[this.actualLength];
    }

    private long checkedByteOffset(int index) {
        if (index < 0 || index >= this.actualLength) {
            throw new IndexOutOfBoundsException("index " + index);
        }
        return FastAtomicIntArray.byteOffset(index);
    }

    private static long byteOffset(int index) {
        return ((long)index << shift) + (long)base;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int get(int index) {
        int result = 0;
        int[] array = this.array;
        int length = this.length;
        for (int shardIdx = 0; shardIdx < this.shards; ++shardIdx) {
            result += unsafe.getIntVolatile(array, this.checkedByteOffset(index + shardIdx * length << falseSharingShift));
        }
        return result;
    }

    @Override
    public int getAndIncrement(int index) {
        return this.getAndAdd(index, 1);
    }

    @Override
    public int getAndAdd(int index, int delta) {
        int shardIdx = this.shards - 1 & this.hash(Thread.currentThread().getId());
        long byteOffset = this.checkedByteOffset(index + shardIdx * this.length << falseSharingShift);
        return unsafe.getAndAddInt(this.array, byteOffset, delta);
    }

    private int hash(long threadId) {
        return (int)(threadId >>> 16 ^ threadId);
    }

    @Override
    public int incrementAndGet(int index) {
        return this.addAndGet(index, 1);
    }

    @Override
    public int addAndGet(int index, int delta) {
        return this.getAndAdd(index, delta) + delta;
    }

    @Override
    public void reset() {
        unsafe.setMemory(this.array, FastAtomicIntArray.byteOffset(0), (long)this.array.length * (long)scale, (byte)0);
    }

    @Override
    public long fillSortedKvs(LongBuf longBuf) {
        long totalCount = 0L;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int count = this.get(i);
            if (count <= 0) continue;
            longBuf.write(i, count);
            totalCount += (long)count;
        }
        return totalCount;
    }

    static {
        if (!NumUtils.isPowerOfTwo(scale)) {
            throw new Error("data type scale not a power of two");
        }
    }
}

