/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util.collections;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MapUtils {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static <K, V> Map<K, V> of(K k, V v) {
        Map<K, V> map = MapUtils.createHashMap(1);
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> createHashMap(int keyNum) {
        return new HashMap(MapUtils.getFitCapacity(keyNum));
    }

    public static <K, V> Map<K, V> createHashMap(int keyNum, float loadFactor) {
        return new HashMap(MapUtils.getFitCapacity(keyNum, loadFactor));
    }

    public static <K, V> ConcurrentHashMap<K, V> createConcHashMap(int keyNum, float loadFactor) {
        return new ConcurrentHashMap(MapUtils.getFitCapacity(keyNum, loadFactor));
    }

    public static <K, V> Map<K, V> createLinkedHashMap(int keyNum) {
        return new LinkedHashMap(MapUtils.getFitCapacity(keyNum));
    }

    public static int getFitCapacity(int keyNum) {
        return MapUtils.getFitCapacity(keyNum, 0.75f);
    }

    public static int getFitCapacity(int keyNum, float loadFactor) {
        return (int)((float)keyNum / loadFactor) + 1;
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return !MapUtils.isEmpty(map);
    }

    private MapUtils() {
    }
}

