/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import cn.myperf4j.base.util.StrUtils;
import cn.myperf4j.base.util.collections.SetUtils;
import java.util.List;
import java.util.Set;

public final class PkgExpUtils {
    private PkgExpUtils() {
    }

    public static Set<String> parse(String expStr) {
        int leftIdx = expStr.indexOf(91);
        if (leftIdx < 0) {
            return SetUtils.of(expStr);
        }
        int rightIdx = expStr.indexOf(93, leftIdx);
        if (rightIdx < 0) {
            throw new IllegalArgumentException("PkgExpUtils.parse(\"" + expStr + "\"): '[' always paired with ']'");
        }
        String prefixStr = expStr.substring(0, leftIdx);
        String suffixStr = rightIdx + 1 < expStr.length() ? expStr.substring(rightIdx + 1) : "";
        String elementsStr = expStr.substring(leftIdx + 1, rightIdx);
        List<String> elements = StrUtils.splitAsList(elementsStr, ',');
        Set<String> result = SetUtils.createHashSet(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            String subExpStr = prefixStr.concat(elements.get(i)).concat(suffixStr);
            result.addAll(PkgExpUtils.parse(subExpStr));
        }
        return result;
    }
}

