/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.util;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Logger {
    private static final ThreadLocal<DateFormat> TO_MILLS_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    private static boolean debugEnable;
    private static final String PREFIX = " [MyPerf4J] ";
    private static final String INFO_LEVEL = "INFO ";
    private static final String DEBUG_LEVEL = "DEBUG ";
    private static final String WARN_LEVEL = "WARN ";
    private static final String ERROR_LEVEL = "ERROR ";

    private Logger() {
    }

    public static void setDebugEnable(boolean debugEnable) {
        Logger.debugEnable = debugEnable;
    }

    public static boolean isDebugEnable() {
        return debugEnable;
    }

    public static void info(String msg) {
        System.out.println(Logger.getPrefix(INFO_LEVEL) + msg);
    }

    private static String getPrefix(String logLevel) {
        return Logger.getToMillisStr(new Date()) + PREFIX + logLevel + "[" + Thread.currentThread().getName() + "] ";
    }

    private static String getToMillisStr(Date date) {
        return TO_MILLS_DATE_FORMAT.get().format(date);
    }

    public static void debug(String msg) {
        if (debugEnable) {
            System.out.println(Logger.getPrefix(DEBUG_LEVEL) + msg);
        }
    }

    public static void warn(String msg) {
        System.out.println(Logger.getPrefix(WARN_LEVEL) + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warn(String msg, Throwable throwable) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println(Logger.getPrefix(WARN_LEVEL) + msg + " " + throwable.getMessage());
            throwable.printStackTrace(System.out);
        }
    }

    public static void error(String msg) {
        System.err.println(Logger.getPrefix(ERROR_LEVEL) + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String msg, Throwable throwable) {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(Logger.getPrefix(ERROR_LEVEL) + msg + " " + throwable.getMessage());
            throwable.printStackTrace(System.err);
        }
    }
}

