/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.standard;

import cn.myperf4j.base.metric.JvmGcMetricsV3;
import cn.myperf4j.base.metric.formatter.JvmGcMetricsV3Formatter;
import cn.myperf4j.base.util.SysProperties;
import cn.myperf4j.base.util.text.DateFormatUtils;
import java.util.List;

public class StdJvmGcMetricsV3Formatter
implements JvmGcMetricsV3Formatter {
    private static final String TITLE_FORMAT = "%-20s%15s%15s%15s%n";
    private static final String DATA_FORMAT = "%-20s%15d%15d%15.2f%n";

    @Override
    public String format(List<JvmGcMetricsV3> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = new StringBuilder((metricsList.size() + 2) * 91);
        sb.append("MyPerf4J JVM GC MetricsV2 [").append(DateFormatUtils.format(startMillis)).append(", ").append(DateFormatUtils.format(stopMillis)).append(']').append(SysProperties.LINE_SEPARATOR);
        sb.append(String.format(TITLE_FORMAT, "GcName", "GcCount", "GcTime", "AvgGcTime"));
        if (metricsList.isEmpty()) {
            return sb.toString();
        }
        for (int i = 0; i < metricsList.size(); ++i) {
            JvmGcMetricsV3 metrics = metricsList.get(i);
            String gcName = metrics.getGcName();
            long gcCount = metrics.getGcCount();
            long gcTime = metrics.getGcTime();
            double avgGcTime = metrics.getAvgGcTime();
            sb.append(String.format(DATA_FORMAT, gcName, gcCount, gcTime, avgGcTime));
        }
        return sb.toString();
    }
}

