/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.standard;

import cn.myperf4j.base.metric.JvmClassMetrics;
import cn.myperf4j.base.metric.formatter.JvmClassMetricsFormatter;
import cn.myperf4j.base.util.SysProperties;
import cn.myperf4j.base.util.text.DateFormatUtils;
import java.util.List;

public final class StdJvmClassMetricsFormatter
implements JvmClassMetricsFormatter {
    private static final String TITLE_FORMAT = "%-10s%10s%10s%n";
    private static final String DATA_FORMAT = "%-10d%10d%10d%n";

    @Override
    public String format(List<JvmClassMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = new StringBuilder((metricsList.size() + 2) * 100);
        sb.append("MyPerf4J JVM Class Metrics [").append(DateFormatUtils.format(startMillis)).append(", ").append(DateFormatUtils.format(stopMillis)).append(']').append(SysProperties.LINE_SEPARATOR);
        sb.append(String.format(TITLE_FORMAT, "Total", "Loaded", "Unloaded"));
        if (metricsList.isEmpty()) {
            return sb.toString();
        }
        for (int i = 0; i < metricsList.size(); ++i) {
            JvmClassMetrics metrics = metricsList.get(i);
            sb.append(String.format(DATA_FORMAT, metrics.getTotal(), metrics.getLoaded(), metrics.getUnloaded()));
        }
        return sb.toString();
    }
}

