/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.MethodMetrics;
import cn.myperf4j.base.metric.formatter.MethodMetricsFormatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.collections.ListUtils;
import cn.myperf4j.base.util.net.IpUtils;
import cn.myperf4j.base.util.text.NumFormatUtils;
import java.util.List;

public final class InfluxMethodMetricsFormatter
implements MethodMetricsFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<MethodMetrics> metricsList, long startMillis, long stopMillis) {
        if (ListUtils.isEmpty(metricsList)) {
            return "";
        }
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(MethodMetrics metrics, long startNanos, StringBuilder sb) {
        MethodTag methodTag = metrics.getMethodTag();
        String methodDesc = LineProtocolUtils.processTagOrField(methodTag.getSimpleDesc());
        sb.append("method_metrics").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",ClassName=").append(methodTag.getSimpleClassName()).append(",Method=").append(methodDesc).append(",Type=").append(methodTag.getType()).append(",Level=").append(methodTag.getLevel()).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(" TotalTimePercent=").append(metrics.getTotalTimePercent()).append(",RPS=").append(metrics.getRPS()).append('i').append(",Avg=").append(NumFormatUtils.doubleFormat(metrics.getAvgTime())).append(",Min=").append(metrics.getMinTime()).append('i').append(",Max=").append(metrics.getMaxTime()).append('i').append(",StdDev=").append(NumFormatUtils.doubleFormat(metrics.getStdDev())).append(",Count=").append(metrics.getTotalCount()).append('i').append(",TP50=").append(metrics.getTP50()).append('i').append(",TP90=").append(metrics.getTP90()).append('i').append(",TP95=").append(metrics.getTP95()).append('i').append(",TP99=").append(metrics.getTP99()).append('i').append(",TP999=").append(metrics.getTP999()).append('i').append(",TP9999=").append(metrics.getTP9999()).append('i').append(' ').append(startNanos).append('\n');
    }
}

