/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.formatter.influxdb;

import cn.myperf4j.base.config.ProfilingConfig;
import cn.myperf4j.base.metric.JvmThreadMetrics;
import cn.myperf4j.base.metric.formatter.JvmThreadMetricsFormatter;
import cn.myperf4j.base.util.LineProtocolUtils;
import cn.myperf4j.base.util.net.IpUtils;
import java.util.List;

public class InfluxJvmThreadMetricsFormatter
implements JvmThreadMetricsFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(List<JvmThreadMetrics> metricsList, long startMillis, long stopMillis) {
        StringBuilder sb = (StringBuilder)SB_TL.get();
        try {
            long startNanos = startMillis * 1000L * 1000L;
            int size = metricsList.size();
            for (int i = 0; i < size; ++i) {
                this.appendLineProtocol(metricsList.get(i), startNanos, sb);
            }
            String string = sb.substring(0, Math.max(0, sb.length() - 1));
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    private void appendLineProtocol(JvmThreadMetrics metrics, long startNanos, StringBuilder sb) {
        sb.append("jvm_thread_metrics").append(",AppName=").append(ProfilingConfig.basicConfig().appName()).append(",host=").append(LineProtocolUtils.processTagOrField(IpUtils.getLocalhostName())).append(" TotalStarted=").append(metrics.getTotalStarted()).append('i').append(",Active=").append(metrics.getActive()).append('i').append(",Peak=").append(metrics.getPeak()).append('i').append(",Daemon=").append(metrics.getDaemon()).append('i').append(",New=").append(metrics.getNews()).append('i').append(",Runnable=").append(metrics.getRunnable()).append('i').append(",Blocked=").append(metrics.getBlocked()).append('i').append(",Waiting=").append(metrics.getWaiting()).append('i').append(",TimedWaiting=").append(metrics.getTimedWaiting()).append('i').append(",Terminated=").append(metrics.getTerminated()).append('i').append(' ').append(startNanos).append('\n');
    }
}

