/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.exporter.log.standard;

import cn.myperf4j.base.metric.JvmMemoryMetrics;
import cn.myperf4j.base.metric.exporter.log.AbstractLogJvmMemoryMetricsExporter;
import cn.myperf4j.base.metric.formatter.JvmMemoryMetricsFormatter;
import cn.myperf4j.base.metric.formatter.standard.StdJvmMemoryMetricsFormatter;
import cn.myperf4j.base.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StdLogJvmMemoryMetricsExporter
extends AbstractLogJvmMemoryMetricsExporter {
    private static final JvmMemoryMetricsFormatter METRICS_FORMATTER = new StdJvmMemoryMetricsFormatter();
    private final ConcurrentMap<Long, List<JvmMemoryMetrics>> metricsMap = new ConcurrentHashMap<Long, List<JvmMemoryMetrics>>(8);

    @Override
    public void beforeProcess(long processId, long startMillis, long stopMillis) {
        this.metricsMap.put(processId, new ArrayList(2));
    }

    @Override
    public void process(JvmMemoryMetrics metrics, long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.get(processId);
        if (metricsList != null) {
            metricsList.add(metrics);
        } else {
            Logger.error("StdLogJvmMemoryMetricsExporter.process(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }

    @Override
    public void afterProcess(long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.remove(processId);
        if (metricsList != null) {
            this.logger.logAndFlush(METRICS_FORMATTER.format(metricsList, startMillis, stopMillis));
        } else {
            Logger.error("StdLogJvmMemoryMetricsExporter.afterProcess(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }
}

