/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.exporter.log.standard;

import cn.myperf4j.base.metric.JvmBufferPoolMetrics;
import cn.myperf4j.base.metric.exporter.log.AbstractLogJvmBufferPoolMetricsExporter;
import cn.myperf4j.base.metric.formatter.JvmBufferPoolMetricsFormatter;
import cn.myperf4j.base.metric.formatter.standard.StdJvmBufferPoolMetricsFormatter;
import cn.myperf4j.base.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StdLogJvmBufferPoolMetricsExporter
extends AbstractLogJvmBufferPoolMetricsExporter {
    private static final JvmBufferPoolMetricsFormatter METRICS_FORMATTER = new StdJvmBufferPoolMetricsFormatter();
    private final ConcurrentMap<Long, List<JvmBufferPoolMetrics>> metricsMap = new ConcurrentHashMap<Long, List<JvmBufferPoolMetrics>>(8);

    @Override
    public void beforeProcess(long processId, long startMillis, long stopMillis) {
        this.metricsMap.put(processId, new ArrayList(2));
    }

    @Override
    public void process(JvmBufferPoolMetrics metrics, long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.get(processId);
        if (metricsList != null) {
            metricsList.add(metrics);
        } else {
            Logger.error("StdLogJvmBufferPoolMetricsExporter.process(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }

    @Override
    public void afterProcess(long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.remove(processId);
        if (metricsList != null) {
            this.logger.logAndFlush(METRICS_FORMATTER.format(metricsList, startMillis, stopMillis));
        } else {
            Logger.error("StdLogJvmBufferPoolMetricsExporter.afterProcess(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }
}

