/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.exporter.http.influxdb;

import cn.myperf4j.base.influxdb.InfluxDbClient;
import cn.myperf4j.base.influxdb.InfluxDbClientFactory;
import cn.myperf4j.base.metric.MethodMetrics;
import cn.myperf4j.base.metric.exporter.MethodMetricsExporter;
import cn.myperf4j.base.metric.formatter.MethodMetricsFormatter;
import cn.myperf4j.base.metric.formatter.influxdb.InfluxMethodMetricsFormatter;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.collections.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InfluxHttpMethodMetricsExporter
implements MethodMetricsExporter {
    private static final int BATCH_SIZE = 256;
    private static final MethodMetricsFormatter METRICS_FORMATTER = new InfluxMethodMetricsFormatter();
    private static final InfluxDbClient CLIENT = InfluxDbClientFactory.getClient();
    private final ConcurrentMap<Long, List<MethodMetrics>> metricsMap = new ConcurrentHashMap<Long, List<MethodMetrics>>(8);

    @Override
    public void beforeProcess(long processId, long startMillis, long stopMillis) {
        this.metricsMap.put(processId, new ArrayList(64));
    }

    @Override
    public void process(MethodMetrics metrics, long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.get(processId);
        if (metricsList != null) {
            metricsList.add(metrics);
        } else {
            Logger.error("InfluxHttpMethodMetricsExporter.process(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
        }
    }

    @Override
    public void afterProcess(long processId, long startMillis, long stopMillis) {
        List metricsList = (List)this.metricsMap.remove(processId);
        if (metricsList == null) {
            Logger.warn("InfluxHttpMethodMetricsExporter.afterProcess(" + processId + ", " + startMillis + ", " + stopMillis + "): metricsList is null!!!");
            return;
        }
        if (metricsList.size() <= 256) {
            CLIENT.writeMetricsAsync(METRICS_FORMATTER.format(metricsList, startMillis, stopMillis));
        } else {
            List partition = ListUtils.partition(metricsList, 256);
            for (int i = 0; i < partition.size(); ++i) {
                CLIENT.writeMetricsAsync(METRICS_FORMATTER.format(partition.get(i), startMillis, stopMillis));
            }
        }
    }
}

