/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.collector;

import cn.myperf4j.base.metric.JvmThreadMetrics;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.concurrent.ThreadUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class JvmThreadCollector {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final Method getThreadMethod = JvmThreadCollector.reflectGetThreadsMethod();
    private static final ThreadGroup systemThreadGroup = ThreadUtils.getSystemThreadGroup();

    private static Method reflectGetThreadsMethod() {
        try {
            Method method = Thread.class.getDeclaredMethod("getThreads", new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            Logger.warn("JvmThreadCollector.reflectGetThreadsMethod(): reflect getThreads Method failure!");
            return null;
        }
    }

    private JvmThreadCollector() {
    }

    public static JvmThreadMetrics collectThreadMetrics() {
        int news = 0;
        int runnable = 0;
        int blocked = 0;
        int waiting = 0;
        int timedWaiting = 0;
        int terminated = 0;
        for (Thread thread : JvmThreadCollector.getThreads()) {
            if (thread == null) continue;
            Thread.State state = thread.getState();
            if (state == Thread.State.NEW) {
                ++news;
                continue;
            }
            if (state == Thread.State.RUNNABLE) {
                ++runnable;
                continue;
            }
            if (state == Thread.State.BLOCKED) {
                ++blocked;
                continue;
            }
            if (state == Thread.State.WAITING) {
                ++waiting;
                continue;
            }
            if (state == Thread.State.TIMED_WAITING) {
                ++timedWaiting;
                continue;
            }
            if (state != Thread.State.TERMINATED) continue;
            ++terminated;
        }
        ThreadMXBean mxBean = THREAD_MX_BEAN;
        return new JvmThreadMetrics(mxBean.getTotalStartedThreadCount(), mxBean.getThreadCount(), mxBean.getPeakThreadCount(), mxBean.getDaemonThreadCount(), news, runnable, blocked, waiting, timedWaiting, terminated);
    }

    private static Thread[] getThreads() {
        if (getThreadMethod != null) {
            try {
                return (Thread[])getThreadMethod.invoke(Thread.class, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return ThreadUtils.findThreads(systemThreadGroup, true);
    }
}

