/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.collector;

import cn.myperf4j.base.metric.JvmGcMetricsV3;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JvmGcV3Collector {
    private static final Map<String, GcInfo> lastGcInfoMap = new ConcurrentHashMap<String, GcInfo>(16);

    private JvmGcV3Collector() {
    }

    public static List<JvmGcMetricsV3> collectGcMetrics() {
        List<GarbageCollectorMXBean> gcMXBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        ArrayList<JvmGcMetricsV3> result = new ArrayList<JvmGcMetricsV3>(gcMXBeanList.size());
        int size = gcMXBeanList.size();
        for (int i = 0; i < size; ++i) {
            GcInfo curGcInfo;
            GarbageCollectorMXBean gcMxBean = gcMXBeanList.get(i);
            String gcName = gcMxBean.getName();
            GcInfo lastGcInfo = lastGcInfoMap.put(gcName, curGcInfo = new GcInfo(gcMxBean));
            if (lastGcInfo == null) continue;
            result.add(JvmGcV3Collector.generateGcMetrics(curGcInfo, lastGcInfo));
        }
        return result;
    }

    private static JvmGcMetricsV3 generateGcMetrics(GcInfo cur, GcInfo last) {
        return new JvmGcMetricsV3(cur.gcName, cur.gcCount - last.gcCount, cur.gcTime - last.gcTime);
    }

    private static final class GcInfo {
        private final String gcName;
        private final long gcTime;
        private final long gcCount;

        GcInfo(GarbageCollectorMXBean gcMxBean) {
            this.gcName = gcMxBean.getName();
            this.gcTime = gcMxBean.getCollectionTime();
            this.gcCount = gcMxBean.getCollectionCount();
        }

        public String toString() {
            return "GcInfo{gcName='" + this.gcName + '\'' + ", gcTime=" + this.gcTime + ", gcCount=" + this.gcCount + '}';
        }
    }
}

