/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric.collector;

import cn.myperf4j.base.metric.JvmGcMetrics;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.collections.SetUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Set;

public final class JvmGcCollector {
    private static final Set<String> YOUNG_GC_SET = SetUtils.of("Copy", "ParNew", "PS Scavenge", "G1 Young Generation");
    private static final Set<String> OLD_GC_SET = SetUtils.of("MarkSweepCompact", "PS MarkSweep", "ConcurrentMarkSweep", "G1 Old Generation");
    private static volatile long lastYoungGcTime;
    private static volatile long lastYoungGcCount;
    private static volatile long lastOldGcTime;
    private static volatile long lastOldGcCount;
    private static volatile long lastZGcTime;
    private static volatile long lastZGcCount;
    private static volatile long lastZGcCyclesTime;
    private static volatile long lastZGcCyclesCount;
    private static volatile long lastZGcPausesTime;
    private static volatile long lastZGcPausesCount;

    private JvmGcCollector() {
    }

    public static JvmGcMetrics collectGcMetrics() {
        long youngGcCount = 0L;
        long youngGcTime = 0L;
        long oldGcCount = 0L;
        long oldGcTime = 0L;
        long zGcCount = 0L;
        long zGcTime = 0L;
        long zGcCyclesCount = 0L;
        long zGcCyclesTime = 0L;
        long zGcPausesCount = 0L;
        long zGcPausesTime = 0L;
        List<GarbageCollectorMXBean> gcMXBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        int size = gcMXBeanList.size();
        for (int i = 0; i < size; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMXBeanList.get(i);
            String gcName = gcMxBean.getName();
            if (YOUNG_GC_SET.contains(gcName)) {
                youngGcTime += gcMxBean.getCollectionTime();
                youngGcCount += gcMxBean.getCollectionCount();
                continue;
            }
            if (OLD_GC_SET.contains(gcName)) {
                oldGcTime += gcMxBean.getCollectionTime();
                oldGcCount += gcMxBean.getCollectionCount();
                continue;
            }
            if ("ZGC".equals(gcName)) {
                zGcTime += gcMxBean.getCollectionTime();
                zGcCount += gcMxBean.getCollectionCount();
                continue;
            }
            if ("ZGC Cycles".equals(gcName)) {
                zGcCyclesTime += gcMxBean.getCollectionTime();
                zGcCyclesCount += gcMxBean.getCollectionCount();
                continue;
            }
            if ("ZGC Pauses".equals(gcName)) {
                zGcPausesTime += gcMxBean.getCollectionTime();
                zGcPausesCount += gcMxBean.getCollectionCount();
                continue;
            }
            Logger.debug("Unknown GC: " + gcName);
        }
        JvmGcMetrics jvmGcMetrics = new JvmGcMetrics(youngGcCount - lastYoungGcCount, youngGcTime - lastYoungGcTime, oldGcCount - lastOldGcCount, oldGcTime - lastOldGcTime, zGcCount - lastZGcCount, zGcTime - lastZGcTime, zGcCyclesCount - lastZGcCyclesCount, zGcCyclesTime - lastZGcCyclesTime, zGcPausesCount - lastZGcPausesCount, zGcPausesTime - lastZGcPausesTime);
        lastYoungGcCount = youngGcCount;
        lastYoungGcTime = youngGcTime;
        lastOldGcCount = oldGcCount;
        lastOldGcTime = oldGcTime;
        lastZGcCount = zGcCount;
        lastZGcTime = zGcTime;
        lastZGcCyclesCount = zGcCyclesCount;
        lastZGcCyclesTime = zGcCyclesTime;
        lastZGcPausesCount = zGcPausesCount;
        lastZGcPausesTime = zGcPausesTime;
        return jvmGcMetrics;
    }
}

