/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric;

import cn.myperf4j.base.MethodTag;
import cn.myperf4j.base.metric.Metrics;

public final class MethodMetrics
extends Metrics {
    private static final long serialVersionUID = 7715008537772415621L;
    private static final int TP_50_IDX = 0;
    private static final int TP_90_IDX = 1;
    private static final int TP_95_IDX = 2;
    private static final int TP_99_IDX = 3;
    private static final int TP_999_IDX = 4;
    private static final int TP_9999_IDX = 5;
    private static final int TP_100_IDX = 6;
    private static final double[] TOP_PERCENTILE_ARR = new double[]{0.5, 0.9, 0.95, 0.99, 0.999, 0.9999, 1.0};
    private final int[] tpArr = new int[]{-1, -1, -1, -1, -1, -1, -1};
    private final MethodTag methodTag;
    private final int methodTagId;
    private final long startMillTime;
    private final long stopMillTime;
    private int minTime = -1;
    private double avgTime = -1.0;
    private int maxTime = -1;
    private double stdDev;
    private long totalCount = -1L;
    private long totalTime = -1L;
    private double totalTimePercent;

    private MethodMetrics(MethodTag methodTag, int methodTagId, long startMillTime, long stopMillTime) {
        this.methodTag = methodTag;
        this.methodTagId = methodTagId;
        this.startMillTime = startMillTime;
        this.stopMillTime = stopMillTime;
    }

    public MethodTag getMethodTag() {
        return this.methodTag;
    }

    public int getMethodTagId() {
        return this.methodTagId;
    }

    public int getMinTime() {
        return this.minTime;
    }

    public void setMinTime(int minTime) {
        this.minTime = minTime;
    }

    public double getAvgTime() {
        return this.avgTime;
    }

    public void setAvgTime(double avgTime) {
        this.avgTime = avgTime;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(double stdDev) {
        this.stdDev = stdDev;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public double getTotalTimePercent() {
        return this.totalTimePercent;
    }

    public void setTotalTimePercent(double totalTimePercent) {
        this.totalTimePercent = totalTimePercent;
    }

    public int getTP50() {
        return this.tpArr[0];
    }

    public int getTP90() {
        return this.tpArr[1];
    }

    public int getTP95() {
        return this.tpArr[2];
    }

    public int getTP99() {
        return this.tpArr[3];
    }

    public int getTP999() {
        return this.tpArr[4];
    }

    public int getTP9999() {
        return this.tpArr[5];
    }

    public int getTP100() {
        return this.tpArr[6];
    }

    public int[] getTpArr() {
        return this.tpArr;
    }

    public int getRPS() {
        long seconds = (this.stopMillTime - this.startMillTime) / 1000L;
        seconds = seconds <= 0L ? 1L : seconds;
        return (int)(this.totalCount / seconds);
    }

    public String toString() {
        return "MethodMetrics{methodTag=" + this.methodTag + ", RPS=" + this.getRPS() + ", TP50=" + this.getTP50() + ", TP90=" + this.getTP90() + ", TP95=" + this.getTP95() + ", TP99=" + this.getTP99() + ", TP999=" + this.getTP999() + ", TP9999=" + this.getTP9999() + ", TP100=" + this.getTP100() + ", minTime=" + this.minTime + ", avgTime=" + this.avgTime + ", maxTime=" + this.maxTime + ", stdDev=" + this.stdDev + ", totalCount=" + this.totalCount + ", totalTime=" + this.totalTime + ", totalTimePercent=" + this.totalTimePercent + '}';
    }

    public static MethodMetrics getInstance(MethodTag methodTag, int methodTagId, long startMillTime, long stopMillTime) {
        return new MethodMetrics(methodTag, methodTagId, startMillTime, stopMillTime);
    }

    public static double[] getPercentiles() {
        return TOP_PERCENTILE_ARR;
    }
}

