/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.metric;

import cn.myperf4j.base.metric.Metrics;
import cn.myperf4j.base.util.NumUtils;

public class JvmMemoryMetrics
extends Metrics {
    private static final long serialVersionUID = -1501873958253505089L;
    private final long heapUsed;
    private final long heapMax;
    private final long nonHeapUsed;
    private final long nonHeapMax;
    private final long permGenUsed;
    private final long permGenMax;
    private final long metaspaceUsed;
    private final long metaspaceMax;
    private final long codeCacheUsed;
    private final long codeCacheMax;
    private final long oldGenUsed;
    private final long oldGenMax;
    private final long edenUsed;
    private final long edenMax;
    private final long survivorUsed;
    private final long survivorMax;

    public JvmMemoryMetrics(long heapUsed, long heapMax, long nonHeapUsed, long nonHeapMax, long permGenUsed, long permGenMax, long metaspaceUsed, long metaspaceMax, long codeCacheUsed, long codeCacheMax, long oldGenUsed, long oldGenMax, long edenUsed, long edenMax, long survivorUsed, long survivorMax) {
        this.heapUsed = heapUsed;
        this.heapMax = heapMax;
        this.nonHeapUsed = nonHeapUsed;
        this.nonHeapMax = nonHeapMax;
        this.permGenUsed = permGenUsed;
        this.permGenMax = permGenMax;
        this.metaspaceUsed = metaspaceUsed;
        this.metaspaceMax = metaspaceMax;
        this.codeCacheUsed = codeCacheUsed;
        this.codeCacheMax = codeCacheMax;
        this.oldGenUsed = oldGenUsed;
        this.oldGenMax = oldGenMax;
        this.edenUsed = edenUsed;
        this.edenMax = edenMax;
        this.survivorUsed = survivorUsed;
        this.survivorMax = survivorMax;
    }

    public long getHeapUsed() {
        return this.heapUsed;
    }

    public double getHeapUsedPercent() {
        return NumUtils.getPercent(this.heapUsed, this.heapMax);
    }

    public long getNonHeapUsed() {
        return this.nonHeapUsed;
    }

    public double getNonHeapUsedPercent() {
        return NumUtils.getPercent(this.nonHeapUsed, this.nonHeapMax);
    }

    public long getPermGenUsed() {
        return this.permGenUsed;
    }

    public double getPermGenUsedPercent() {
        return NumUtils.getPercent(this.permGenUsed, this.permGenMax);
    }

    public long getMetaspaceUsed() {
        return this.metaspaceUsed;
    }

    public double getMetaspaceUsedPercent() {
        return NumUtils.getPercent(this.metaspaceUsed, this.metaspaceMax);
    }

    public long getCodeCacheUsed() {
        return this.codeCacheUsed;
    }

    public double getCodeCacheUsedPercent() {
        return NumUtils.getPercent(this.codeCacheUsed, this.codeCacheMax);
    }

    public long getOldGenUsed() {
        return this.oldGenUsed;
    }

    public double getOldGenUsedPercent() {
        return NumUtils.getPercent(this.oldGenUsed, this.oldGenMax);
    }

    public long getEdenUsed() {
        return this.edenUsed;
    }

    public double getEdenUsedPercent() {
        return NumUtils.getPercent(this.edenUsed, this.edenMax);
    }

    public long getSurvivorUsed() {
        return this.survivorUsed;
    }

    public double getSurvivorUsedPercent() {
        return NumUtils.getPercent(this.survivorUsed, this.survivorMax);
    }

    public String toString() {
        return "JvmMemoryMetrics{heapUsed=" + this.heapUsed + ", heapMax=" + this.heapMax + ", nonHeapUsed=" + this.nonHeapUsed + ", nonHeapMax=" + this.nonHeapMax + ", permGenUsed=" + this.permGenUsed + ", permGenMax=" + this.permGenMax + ", metaspaceUsed=" + this.metaspaceUsed + ", metaspaceMax=" + this.metaspaceMax + ", codeCacheUsed=" + this.codeCacheUsed + ", codeCacheMax=" + this.codeCacheMax + ", oldGenUsed=" + this.oldGenUsed + ", oldGenMax=" + this.oldGenMax + ", edenUsed=" + this.edenUsed + ", edenMax=" + this.edenMax + ", survivorUsed=" + this.survivorUsed + ", survivorMax=" + this.survivorMax + "} " + super.toString();
    }
}

