/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.log;

import cn.myperf4j.base.file.AutoRollingFileWriter;
import cn.myperf4j.base.file.DailyRollingFileWriter;
import cn.myperf4j.base.file.HourlyRollingFileWriter;
import cn.myperf4j.base.file.MinutelyRollingFileWriter;
import cn.myperf4j.base.log.ILogger;
import cn.myperf4j.base.util.SysProperties;

public class AutoRollingLogger
implements ILogger {
    private final AutoRollingFileWriter writer;

    AutoRollingLogger(String logFile, String rollingTimeUnit, int reserveFileCount) {
        switch (rollingTimeUnit.toUpperCase()) {
            case "HOURLY": {
                this.writer = new HourlyRollingFileWriter(logFile, reserveFileCount);
                break;
            }
            case "MINUTELY": {
                this.writer = new MinutelyRollingFileWriter(logFile, reserveFileCount);
                break;
            }
            default: {
                this.writer = new DailyRollingFileWriter(logFile, reserveFileCount);
            }
        }
    }

    @Override
    public void log(String msg) {
        this.writer.write(msg + SysProperties.LINE_SEPARATOR);
    }

    @Override
    public void logAndFlush(String msg) {
        this.writer.writeAndFlush(msg + SysProperties.LINE_SEPARATOR);
    }

    @Override
    public void flushLog() {
        this.writer.flush();
    }

    @Override
    public void preCloseLog() {
        this.writer.preCloseFile();
    }

    @Override
    public void closeLog() {
        this.writer.closeFile(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.writer.closeFile(true);
    }
}

