/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.http.server;

import cn.myperf4j.base.http.HttpMethod;
import cn.myperf4j.base.http.HttpRequest;
import cn.myperf4j.base.http.HttpRespStatus;
import cn.myperf4j.base.http.HttpResponse;
import cn.myperf4j.base.http.server.Dispatcher;
import cn.myperf4j.base.http.server.QueryStringDecoder;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.StrUtils;
import cn.myperf4j.base.util.concurrent.ExecutorManager;
import cn.myperf4j.base.util.concurrent.ThreadUtils;
import cn.myperf4j.base.util.io.InputStreamUtils;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleHttpServer {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final HttpServer server;

    public SimpleHttpServer(Builder builder) {
        try {
            this.server = HttpServer.create(new InetSocketAddress(builder.port), 0);
            this.server.createContext("/", new DispatchHandler(builder.dispatcher));
            this.server.setExecutor(this.generateExecutor(builder));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Executor generateExecutor(Builder builder) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(builder.minWorkers, builder.maxWorkers, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(builder.acceptCnt), ThreadUtils.newThreadFactory("MyPerf4J-HttpServer-"), new ThreadPoolExecutor.DiscardPolicy());
        ExecutorManager.addExecutorService(executor);
        return executor;
    }

    public void startAsync() {
        this.executor.execute(this::start);
    }

    public void start() {
        InetSocketAddress address = this.server.getAddress();
        Logger.info("SimpleHttpServer listen on " + address.getHostName() + ":" + address.getPort());
        this.server.start();
    }

    public void stop() {
        this.server.stop(3);
    }

    public static class Builder {
        private static final int DEFAULT_MIN_WORKERS = 1;
        private static final int DEFAULT_MAX_WORKERS = 2;
        private static final int DEFAULT_ACCEPT_CNT = 1024;
        private int port;
        private int minWorkers = 1;
        private int maxWorkers = 2;
        private int acceptCnt = 1024;
        private Dispatcher dispatcher;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder minWorkers(int minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public Builder maxWorkers(int maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public Builder acceptCnt(int acceptCnt) {
            this.acceptCnt = acceptCnt;
            return this;
        }

        public Builder dispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public SimpleHttpServer build() {
            return new SimpleHttpServer(this);
        }
    }

    private static class DispatchHandler
    implements HttpHandler {
        private static final ThreadLocal<StringBuilder> URL_SB = ThreadLocal.withInitial(() -> new StringBuilder(128));
        private final Dispatcher dispatcher;

        DispatchHandler(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            HttpMethod httpMethod = HttpMethod.parse(exchange.getRequestMethod());
            if (httpMethod == HttpMethod.UNKNOWN) {
                exchange.sendResponseHeaders(HttpRespStatus.METHOD_NOT_ALLOWED.code(), 0L);
                OutputStream os = exchange.getResponseBody();
                os.write("".getBytes(StandardCharsets.UTF_8));
                os.close();
                return;
            }
            try {
                HttpRequest httpRequest = this.parseHttpRequest(exchange, httpMethod);
                HttpResponse response = this.dispatcher.dispatch(httpRequest);
                OutputStream responseBody = exchange.getResponseBody();
                Headers respHeaders = exchange.getResponseHeaders();
                respHeaders.putAll((Map<? extends String, ? extends List<String>>)response.getHeaders().headers());
                exchange.sendResponseHeaders(response.getStatus().code(), 0L);
                responseBody.write(response.getBody());
                responseBody.flush();
            }
            catch (Exception e) {
                Logger.error("DispatchHandler.handle()", e);
            }
            finally {
                exchange.close();
            }
        }

        private HttpRequest parseHttpRequest(HttpExchange exchange, HttpMethod httpMethod) throws IOException {
            URI uri = exchange.getRequestURI();
            HttpRequest.Builder reqBuilder = new HttpRequest.Builder().path(uri.getPath()).url(this.buildUrl(exchange)).headers(exchange.getRequestHeaders()).params(this.parseParams(uri.getRawQuery())).method(httpMethod, InputStreamUtils.toBytes(exchange.getRequestBody()));
            return reqBuilder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String buildUrl(HttpExchange exchange) {
            StringBuilder sb = URL_SB.get();
            try {
                InetSocketAddress localAddr = exchange.getLocalAddress();
                URI uri = exchange.getRequestURI();
                sb.append("http://").append(localAddr.getHostString()).append(':').append(localAddr.getPort()).append(uri.getPath()).append('?').append(uri.getRawQuery());
                String string = sb.toString();
                return string;
            }
            finally {
                sb.setLength(0);
            }
        }

        private Map<String, List<String>> parseParams(String rawQuery) {
            if (StrUtils.isBlank(rawQuery)) {
                return Collections.emptyMap();
            }
            return new QueryStringDecoder(rawQuery, StandardCharsets.UTF_8, false).parameters();
        }
    }
}

