/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.http.server;

import cn.myperf4j.base.util.StrUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryStringDecoder {
    public static final String EMPTY_STRING = "";
    public static final char SPACE = ' ';
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private static final ThreadLocal<TempBuf> DECODE_TEMP_BUF = ThreadLocal.withInitial(() -> new TempBuf(1024));
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private final boolean semicolonIsNormalChar;
    private int pathEndIdx;
    private Map<String, List<String>> params;

    public QueryStringDecoder(String uri, Charset charset, boolean hasPath) {
        this(uri, charset, hasPath, 1024);
    }

    public QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams) {
        this(uri, charset, hasPath ? -1 : 0, maxParams, false);
    }

    public QueryStringDecoder(String uri, Charset charset, int pathEndIdx, int maxParams, boolean semicolonIsNormalChar) {
        if (uri == null || charset == null || maxParams <= 0) {
            throw new IllegalArgumentException("uri == null || charset == null || maxParams <= 0");
        }
        this.uri = uri;
        this.charset = charset;
        this.maxParams = maxParams;
        this.pathEndIdx = pathEndIdx;
        this.semicolonIsNormalChar = semicolonIsNormalChar;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams, this.semicolonIsNormalChar);
        }
        return this.params;
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String str, int from, Charset charset, int paramsLimit, boolean semicolonIsNormalChar) {
        int i;
        int len = str.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        if (str.charAt(from) == '?') {
            ++from;
        }
        TempBuf tempBuf = DECODE_TEMP_BUF.get();
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int nameStart = from;
        int valueStart = -1;
        block6: for (i = from; i < len; ++i) {
            switch (str.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case ';': {
                    if (semicolonIsNormalChar) break;
                }
                case '&': {
                    if (QueryStringDecoder.addParam(str, nameStart, valueStart, i, params, charset, tempBuf) && --paramsLimit == 0) {
                        return params;
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block6;
                }
            }
        }
        QueryStringDecoder.addParam(str, nameStart, valueStart, i, params, charset, tempBuf);
        return params;
    }

    private static boolean addParam(String s, int nameStart, int valueStart, int valueEnd, Map<String, List<String>> params, Charset charset, TempBuf tempBuf) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = QueryStringDecoder.decodeComponent(s, nameStart, valueStart - 1, charset, false, tempBuf);
        String value = QueryStringDecoder.decodeComponent(s, valueStart, valueEnd, charset, false, tempBuf);
        params.computeIfAbsent(name, k -> new ArrayList(1)).add(value);
        return true;
    }

    private static String decodeComponent(String s, int from, int toExcluded, Charset charset, boolean isPath, TempBuf tempBuf) {
        int len = toExcluded - from;
        if (len <= 0) {
            return EMPTY_STRING;
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        byte[] buf = tempBuf.byteBuf(decodedCapacity);
        char[] charBuf = tempBuf.charBuf(len);
        s.getChars(from, firstEscaped, charBuf, 0);
        int charBufIdx = firstEscaped - from;
        return QueryStringDecoder.decodeComponent(s, firstEscaped, toExcluded, charset, isPath, buf, charBuf, charBufIdx);
    }

    private static String decodeComponent(String str, int firstEscaped, int toExcluded, Charset charset, boolean isPath, byte[] byteBuf, char[] charBuf, int charBufIdx) {
        for (int i = firstEscaped; i < toExcluded; ++i) {
            int c = str.charAt(i);
            if (c != 37) {
                charBuf[charBufIdx++] = c != 43 || isPath ? c : 32;
                continue;
            }
            int byteBufIdx = 0;
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + str);
                }
                byteBuf[byteBufIdx++] = StrUtils.decodeHexByte(str, i + 1);
            } while ((i += 3) < toExcluded && str.charAt(i) == '%');
            --i;
            String decodedStr = new String(byteBuf, 0, byteBufIdx, charset);
            decodedStr.getChars(0, decodedStr.length(), charBuf, charBufIdx);
            charBufIdx += decodedStr.length();
        }
        return new String(charBuf, 0, charBufIdx);
    }

    private static int findPathEndIndex(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c != '?' && c != '#') continue;
            return i;
        }
        return len;
    }

    private static final class TempBuf {
        private final char[] chars;
        private final byte[] bytes;

        TempBuf(int bufSize) {
            this.chars = new char[bufSize];
            this.bytes = new byte[bufSize];
        }

        public char[] charBuf(int size) {
            if (size <= this.chars.length) {
                return this.chars;
            }
            return new char[size];
        }

        public byte[] byteBuf(int size) {
            if (size <= this.bytes.length) {
                return this.bytes;
            }
            return new byte[size];
        }
    }
}

