/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.http;

import cn.myperf4j.base.http.HttpHeaders;
import cn.myperf4j.base.http.HttpMethod;
import cn.myperf4j.base.util.StrUtils;
import cn.myperf4j.base.util.collections.ArrayUtils;
import cn.myperf4j.base.util.collections.MapUtils;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public final class HttpRequest {
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final ThreadLocal<StringBuilder> SB_TL = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(512);
        }
    };
    private final String path;
    private final String url;
    private final HttpMethod method;
    private final HttpHeaders headers;
    private final Map<String, List<String>> params;
    private final byte[] body;
    private String fullUrl;

    public HttpRequest(Builder builder) {
        this.path = builder.path;
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers;
        this.params = builder.params;
        this.body = builder.body;
        this.fullUrl = "";
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getParams() {
        return this.params;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFullUrl() {
        if (StrUtils.isNotEmpty(this.fullUrl)) {
            return this.fullUrl;
        }
        this.fullUrl = this.createFullUrl();
        return this.fullUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFullUrl() {
        StringBuilder sb = SB_TL.get();
        try {
            if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
                sb.append("http://");
            }
            sb.append(this.url);
            if (MapUtils.isEmpty(this.params)) {
                String string = sb.toString();
                return string;
            }
            if (!StrUtils.isContains(this.url, '?')) {
                sb.append('?');
            } else if (!StrUtils.isEndWith(this.url, '?')) {
                sb.append('&');
            }
            for (Map.Entry<String, List<String>> param : this.params.entrySet()) {
                List<String> values = param.getValue();
                values.forEach(v -> sb.append((String)param.getKey()).append('=').append((String)v).append('&'));
            }
            String string = sb.substring(0, sb.length() - 1);
            return string;
        }
        finally {
            sb.setLength(0);
        }
    }

    public String getParam(String key) {
        List<String> values = this.params.get(key);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public Boolean getBoolParam(String key) {
        String value = this.getParam(key);
        return Boolean.valueOf(value);
    }

    public String toString() {
        return "HttpRequest{url='" + this.url + '\'' + ", method=" + (Object)((Object)this.method) + ", headers=" + this.headers + ", params=" + this.params + '}';
    }

    public static class Builder {
        private String path;
        private String url;
        private HttpMethod method = HttpMethod.GET;
        private HttpHeaders headers = HttpHeaders.defaultHeaders();
        private Map<String, List<String>> params;
        private byte[] body = HttpRequest.access$600();

        public Builder path(String path) {
            if (StrUtils.isBlank(path)) {
                throw new IllegalArgumentException("path is blank!");
            }
            this.path = path;
            return this;
        }

        public Builder url(String url) {
            if (StrUtils.isBlank(url)) {
                throw new IllegalArgumentException("url is blank!");
            }
            this.url = url;
            return this;
        }

        public Builder params(Map<String, List<String>> params) {
            this.params = params;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = new HttpHeaders(headers);
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder head() {
            return this.method(HttpMethod.HEAD, EMPTY_BODY);
        }

        public Builder get() {
            return this.method(HttpMethod.GET, EMPTY_BODY);
        }

        public Builder post(byte[] body) {
            return this.method(HttpMethod.POST, body);
        }

        public Builder post(String body) {
            return this.method(HttpMethod.POST, body.getBytes(StandardCharsets.UTF_8));
        }

        public Builder method(HttpMethod method, byte[] body) {
            if (method == null) {
                throw new IllegalArgumentException("method is null!");
            }
            if (ArrayUtils.isNotEmpty(body) && !method.isPermitsBody()) {
                throw new IllegalArgumentException("method " + (Object)((Object)method) + " must not have a request body!");
            }
            if (ArrayUtils.isEmpty(body) && method.isPermitsBody()) {
                throw new IllegalArgumentException("method " + (Object)((Object)method) + " must have a request body!");
            }
            this.method = method;
            this.body = body;
            return this;
        }

        public HttpRequest build() {
            if (this.url == null) {
                throw new IllegalStateException("url is null!");
            }
            return new HttpRequest(this);
        }
    }
}

