/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.http;

import cn.myperf4j.base.util.collections.MapUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class HttpHeaders {
    private final Map<String, List<String>> headers;

    public HttpHeaders(int size) {
        this.headers = MapUtils.createHashMap(size);
    }

    public HttpHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String get(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getValues(String name) {
        return this.headers.get(name);
    }

    public void set(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.headers.put(name, values);
        } else {
            values.clear();
        }
        values.add(value);
    }

    public void add(String name, String value) {
        this.headers.computeIfAbsent(name, k -> new ArrayList(1)).add(value);
    }

    public List<String> names() {
        return new ArrayList<String>(this.headers.keySet());
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static HttpHeaders defaultHeaders() {
        HttpHeaders headers = new HttpHeaders(6);
        headers.set("User-Agent", "MyPerf4J");
        headers.set("Connection", "Keep-Alive");
        headers.set("Charset", StandardCharsets.UTF_8.name());
        return headers;
    }
}

