/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.util.PkgExpUtils;
import cn.myperf4j.base.util.StrMatchUtils;
import cn.myperf4j.base.util.StrUtils;
import java.util.HashSet;
import java.util.Set;

public final class ProfilingFilter {
    private static final Set<String> excludePackagePrefix = new HashSet<String>();
    private static final Set<String> excludePackageExp = new HashSet<String>();
    private static final Set<String> includePackagePrefix = new HashSet<String>();
    private static final Set<String> includePackageExp = new HashSet<String>();
    private static final Set<String> excludeMethods = new HashSet<String>();
    private static final Set<String> excludeClassLoader = new HashSet<String>();

    private ProfilingFilter() {
    }

    public static boolean isNotNeedInject(String innerClassName) {
        if (innerClassName == null) {
            return false;
        }
        if (innerClassName.indexOf(36) >= 0) {
            return true;
        }
        return ProfilingFilter.isMatch(innerClassName, excludePackagePrefix, excludePackageExp);
    }

    private static boolean isMatch(String innerClassName, Set<String> pkgPrefixSet, Set<String> pkgExpSet) {
        for (String prefix : pkgPrefixSet) {
            if (!innerClassName.startsWith(prefix)) continue;
            return true;
        }
        for (String exp : pkgExpSet) {
            if (!StrMatchUtils.isMatch(innerClassName, exp)) continue;
            return true;
        }
        return false;
    }

    public static void addExcludePackage(String pkg) {
        if (StrUtils.isNotEmpty(pkg)) {
            ProfilingFilter.addPackages(pkg, excludePackagePrefix, excludePackageExp);
        }
    }

    private static void addPackages(String packages, Set<String> pkgPrefixSet, Set<String> pkgExpSet) {
        Set<String> pkgSet = PkgExpUtils.parse(packages);
        for (String pkg : pkgSet) {
            if ((pkg = ProfilingFilter.preprocess(pkg)).indexOf(42) > 0) {
                pkgExpSet.add(pkg);
                continue;
            }
            pkgPrefixSet.add(pkg);
        }
    }

    private static String preprocess(String pkg) {
        return pkg.replace('.', '/').trim();
    }

    public static boolean isNeedInject(String innerClassName) {
        if (innerClassName == null) {
            return false;
        }
        return ProfilingFilter.isMatch(innerClassName, includePackagePrefix, includePackageExp);
    }

    public static void addIncludePackage(String pkg) {
        if (StrUtils.isNotEmpty(pkg)) {
            ProfilingFilter.addPackages(pkg, includePackagePrefix, includePackageExp);
        }
    }

    public static boolean isNotNeedInjectMethod(String methodName) {
        if (methodName == null) {
            return false;
        }
        if (ProfilingFilter.isSpecialMethod(methodName)) {
            return true;
        }
        return excludeMethods.contains(methodName);
    }

    private static boolean isSpecialMethod(String methodName) {
        int symbolIndex = methodName.indexOf(36);
        if (symbolIndex < 0) {
            return false;
        }
        int leftParenIndex = methodName.indexOf(40);
        return leftParenIndex < 0 || symbolIndex < leftParenIndex;
    }

    public static void addExcludeMethods(String method) {
        if (method != null) {
            excludeMethods.add(method.trim());
        }
    }

    public static void addExcludeClassLoader(String classLoader) {
        excludeClassLoader.add(classLoader);
    }

    public static boolean isNotNeedInjectClassLoader(String classLoader) {
        return excludeClassLoader.contains(classLoader);
    }

    static {
        excludePackagePrefix.add("java/");
        excludePackagePrefix.add("javax/");
        excludePackagePrefix.add("sun/");
        excludePackagePrefix.add("com/sun/");
        excludePackagePrefix.add("com/intellij/");
        excludePackagePrefix.add("cn/myperf4j/");
        includePackagePrefix.add("net/paoding/rose/jade/context/JadeInvocationHandler");
        includePackagePrefix.add("org/apache/ibatis/binding/MapperProxy");
        includePackagePrefix.add("com/alibaba/dubbo/rpc/proxy/InvokerInvocationHandler");
        includePackagePrefix.add("org/apache/dubbo/rpc/proxy/InvokerInvocationHandler");
        includePackagePrefix.add("com/alipay/sofa/rpc/proxy/jdk/JDKInvocationHandler");
        includePackagePrefix.add("com/weibo/api/motan/proxy/RefererInvocationHandler");
        excludeMethods.add("main");
        excludeMethods.add("premain");
        excludeMethods.add("getClass");
        excludeMethods.add("hashCode");
        excludeMethods.add("equals");
        excludeMethods.add("clone");
        excludeMethods.add("toString");
        excludeMethods.add("notify");
        excludeMethods.add("notifyAll");
        excludeMethods.add("wait");
        excludeMethods.add("finalize");
        excludeMethods.add("afterPropertiesSet");
    }
}

