/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.util.StrMatchUtils;
import cn.myperf4j.base.util.collections.MapUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class LevelMappingFilter {
    private static final Map<String, List<String>> LEVEL_EXPS_MAP = MapUtils.createLinkedHashMap(20);

    private LevelMappingFilter() {
    }

    public static String getClassLevel(String simpleClassName) {
        for (Map.Entry<String, List<String>> entry : LEVEL_EXPS_MAP.entrySet()) {
            String level = entry.getKey();
            List<String> mappingExps = entry.getValue();
            for (int i = 0; i < mappingExps.size(); ++i) {
                if (!StrMatchUtils.isMatch(simpleClassName, mappingExps.get(i))) continue;
                return level;
            }
        }
        return "Others";
    }

    public static void putLevelMapping(String classLevel, List<String> expList) {
        LEVEL_EXPS_MAP.put(classLevel, expList);
    }

    static {
        LEVEL_EXPS_MAP.put("Controller", Collections.singletonList("*Controller"));
        LEVEL_EXPS_MAP.put("Interceptor", Collections.singletonList("*Interceptor"));
        LEVEL_EXPS_MAP.put("Producer", Collections.singletonList("*Producer"));
        LEVEL_EXPS_MAP.put("Consumer", Collections.singletonList("*Consumer"));
        LEVEL_EXPS_MAP.put("Listener", Collections.singletonList("*Listener"));
        LEVEL_EXPS_MAP.put("Filter", Collections.singletonList("*Filter"));
        LEVEL_EXPS_MAP.put("Handler", Collections.singletonList("*Handler"));
        LEVEL_EXPS_MAP.put("Processor", Collections.singletonList("*Processor"));
        LEVEL_EXPS_MAP.put("Dispatcher", Collections.singletonList("*Dispatcher"));
        LEVEL_EXPS_MAP.put("Api", Arrays.asList("*Api", "*ApiImpl"));
        LEVEL_EXPS_MAP.put("Service", Arrays.asList("*Service", "*ServiceImpl"));
        LEVEL_EXPS_MAP.put("Cache", Arrays.asList("*Cache", "*CacheImpl"));
        LEVEL_EXPS_MAP.put("DAO", Collections.singletonList("*DAO"));
        LEVEL_EXPS_MAP.put("Utils", Collections.singletonList("*Utils"));
    }
}

