/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.util.Logger;
import cn.myperf4j.base.util.StrUtils;

public class InfluxDbConfig {
    private String version;
    private String host;
    private int port;
    private String orgName;
    private String database;
    private int connectTimeout;
    private int readTimeout;
    private String username;
    private String password;

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
    }

    public String host() {
        return this.host;
    }

    public void host(String host) {
        this.host = host;
    }

    public int port() {
        return this.port;
    }

    public void port(int port) {
        this.port = port;
    }

    public String orgName() {
        return this.orgName;
    }

    public void orgName(String ortName) {
        this.orgName = ortName;
    }

    public String database() {
        return this.database;
    }

    public void database(String database) {
        this.database = database;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public void connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public void readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    public String password() {
        return this.password;
    }

    public void password(String password) {
        this.password = password;
    }

    public String toString() {
        return "InfluxDbConfig{version='" + this.version + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", orgName='" + this.orgName + '\'' + ", database='" + this.database + '\'' + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + '}';
    }

    public static InfluxDbConfig loadInfluxDbConfig() {
        Integer port;
        String host;
        String version = MyProperties.getStr(PropertyKeys.InfluxDB.VERSION);
        if (StrUtils.isBlank(version)) {
            version = "1.x";
            Logger.info(PropertyKeys.InfluxDB.VERSION.key() + " is not configured, so use '1.x' as default version.");
        }
        if (StrUtils.isBlank(host = MyProperties.getStr(PropertyKeys.InfluxDB.HOST))) {
            host = "127.0.0.1";
            Logger.info(PropertyKeys.InfluxDB.HOST.key() + " is not configured, so use '127.0.0.1' as default host.");
        }
        if ((port = MyProperties.getInt(PropertyKeys.InfluxDB.PORT)) == null) {
            port = 8086;
            Logger.info(PropertyKeys.InfluxDB.PORT.key() + " is not configured, so use '8086' as default port.");
        }
        InfluxDbConfig config = new InfluxDbConfig();
        config.version(version);
        config.host(host);
        config.port(port);
        config.orgName(MyProperties.getStr(PropertyKeys.InfluxDB.ORG_NAME));
        config.database(MyProperties.getStr(PropertyKeys.InfluxDB.DATABASE));
        config.username(MyProperties.getStr(PropertyKeys.InfluxDB.USERNAME));
        config.password(MyProperties.getStr(PropertyKeys.InfluxDB.PASSWORD));
        config.connectTimeout(MyProperties.getInt(PropertyKeys.InfluxDB.CONN_TIMEOUT, 3000));
        config.readTimeout(MyProperties.getInt(PropertyKeys.InfluxDB.READ_TIMEOUT, 5000));
        return config;
    }
}

