/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.config;

import cn.myperf4j.base.config.MyProperties;
import cn.myperf4j.base.constant.PropertyKeys;
import cn.myperf4j.base.util.StrUtils;

public class FilterConfig {
    private String excludeClassLoaders;
    private String includePackages;
    private String excludePackages;
    private String excludeMethods;
    private boolean excludePrivateMethod;

    public String excludeClassLoaders() {
        return this.excludeClassLoaders;
    }

    public void excludeClassLoaders(String excludeClassLoaders) {
        this.excludeClassLoaders = excludeClassLoaders;
    }

    public String includePackages() {
        return this.includePackages;
    }

    public void includePackages(String includePackages) {
        this.includePackages = includePackages;
    }

    public String excludePackages() {
        return this.excludePackages;
    }

    public void excludePackages(String excludePackages) {
        this.excludePackages = excludePackages;
    }

    public String excludeMethods() {
        return this.excludeMethods;
    }

    public void excludeMethods(String excludeMethods) {
        this.excludeMethods = excludeMethods;
    }

    public boolean excludePrivateMethod() {
        return this.excludePrivateMethod;
    }

    public void excludePrivateMethod(boolean excludePrivateMethod) {
        this.excludePrivateMethod = excludePrivateMethod;
    }

    public String toString() {
        return "FilterConfig{excludeClassLoaders='" + this.excludeClassLoaders + '\'' + ", includePackages='" + this.includePackages + '\'' + ", excludePackages='" + this.excludePackages + '\'' + ", excludeMethods='" + this.excludeMethods + '\'' + ", excludePrivateMethod=" + this.excludePrivateMethod + '}';
    }

    public static FilterConfig loadFilterConfig() {
        String includePackages = MyProperties.getStr(PropertyKeys.Filter.PACKAGES_INCLUDE);
        if (StrUtils.isBlank(includePackages)) {
            throw new IllegalArgumentException(PropertyKeys.Filter.PACKAGES_INCLUDE.key() + " or " + PropertyKeys.Filter.PACKAGES_INCLUDE.legacyKey() + " is required!!!");
        }
        FilterConfig config = new FilterConfig();
        config.includePackages(includePackages);
        config.excludeClassLoaders(MyProperties.getStr(PropertyKeys.Filter.CLASS_LOADERS_EXCLUDE));
        config.excludePackages(MyProperties.getStr(PropertyKeys.Filter.PACKAGES_EXCLUDE));
        config.excludeMethods(MyProperties.getStr(PropertyKeys.Filter.METHODS_EXCLUDE));
        config.excludePrivateMethod(MyProperties.getBoolean(PropertyKeys.Filter.METHODS_EXCLUDE_PRIVATE, true));
        return config;
    }
}

