/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.base.buffer;

import cn.myperf4j.base.buffer.LongBufPool;
import cn.myperf4j.base.util.NumUtils;
import java.util.Arrays;

public class LongBuf
implements AutoCloseable {
    private final long[] buf;
    private int writerIndex;
    private final LongBufPool pool;

    public LongBuf(int capacity, LongBufPool pool) {
        this.buf = new long[capacity];
        this.writerIndex = 0;
        this.pool = pool;
    }

    public LongBuf(int capacity) {
        this.buf = new long[capacity];
        this.writerIndex = 0;
        this.pool = null;
    }

    public void write(long kv) {
        this.ensureWritable(1);
        this.buf[this.writerIndex++] = kv;
    }

    public void write(int key, int value) {
        this.ensureWritable(1);
        this.buf[this.writerIndex++] = NumUtils.composeKv(key, value);
    }

    private void ensureWritable(int minWritableSize) {
        if (minWritableSize > this.buf.length - this.writerIndex) {
            throw new IndexOutOfBoundsException("LongBuf minWritableSize(" + minWritableSize + ") + writerIndex(" + this.writerIndex + ") exceed buf.length(" + this.buf.length + ")");
        }
    }

    private void checkBounds(int index) {
        if (index >= this.buf.length) {
            throw new IndexOutOfBoundsException("LongBuf index(" + index + ") exceed buf.length(" + this.buf.length + ")");
        }
    }

    public int capacity() {
        return this.buf.length;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public long getLong(int index) {
        this.checkBounds(index);
        return this.buf[index];
    }

    public long[] _buf() {
        return this.buf;
    }

    public LongBuf reset() {
        this.writerIndex = 0;
        return this;
    }

    public LongBufPool pool() {
        return this.pool;
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.release(this.reset());
        }
    }

    public String toString() {
        return "LongBuf{buf=" + Arrays.toString(this.buf) + ", writerIndex=" + this.writerIndex + ", pool=" + this.pool + '}';
    }
}

