/*
 * Decompiled with CFR 0.152.
 */
package cn.myperf4j.asm.aop;

import cn.myperf4j.asm.aop.ProfilingClassAdapter;
import cn.myperf4j.base.config.ProfilingFilter;
import cn.myperf4j.base.util.Logger;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.shaded.objectweb.asm.ClassReader;
import org.shaded.objectweb.asm.ClassWriter;

public class ProfilingTransformer
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        String classLoaderName = this.getClassLoaderName(loader);
        try {
            if (ProfilingFilter.isNotNeedInject(className) || !ProfilingFilter.isNeedInject(className)) {
                return classFileBuffer;
            }
            if (loader != null && ProfilingFilter.isNotNeedInjectClassLoader(classLoaderName)) {
                return classFileBuffer;
            }
            Logger.info("ProfilingTransformer.transform(" + classLoaderName + ", " + className + ", classBeingRedefined, protectionDomain, " + classFileBuffer.length + ")...");
            return this.getBytes(loader, className, classFileBuffer);
        }
        catch (Throwable t) {
            Logger.error("ProfilingTransformer.transform(" + classLoaderName + ", " + className + ", " + classBeingRedefined + ", protectionDomain, " + classFileBuffer.length + ")", t);
            return classFileBuffer;
        }
    }

    private String getClassLoaderName(ClassLoader classLoader) {
        return classLoader == null ? "null" : classLoader.getClass().getName();
    }

    private byte[] getBytes(ClassLoader loader, String className, byte[] classFileBuffer) {
        ClassReader cr = new ClassReader(classFileBuffer);
        ClassWriter cw = new ClassWriter(cr, this.computeMax(loader) ? 1 : 2);
        cr.accept(new ProfilingClassAdapter(cw, className), 8);
        return cw.toByteArray();
    }

    private boolean computeMax(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        String loaderName = classLoader.getClass().getName();
        return loaderName.equals("org.apache.catalina.loader.WebappClassLoader") || loaderName.equals("org.apache.catalina.loader.ParallelWebappClassLoader") || loaderName.equals("org.springframework.boot.loader.LaunchedURLClassLoader") || loaderName.equals("org.springframework.boot.loader.launch.LaunchedClassLoader") || loaderName.startsWith("org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders");
    }
}

