﻿using System.Collections;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.CommandWpf;

namespace SelectedItemsTest
{
	class MainWindowViewModel : ObservableObject
    {
        public ObservableCollection<GridDataItem> GridData { get; }

		public MainWindowViewModel()
		{
			GridData = new ObservableCollection<GridDataItem>
			{
				new("Hester", 4),
				new("Franklin", 3),
				new("Tia", 3)
			};
		}

		GridDataItem? _selectedItem;

		public GridDataItem? SelectedGridDataItem
		{
			get => _selectedItem;
			set
			{
				_selectedItem = value; 
				ProcessMultipleSelectedCommand.RaiseCanExecuteChanged();
				ProcessOneSelectedCommand.RaiseCanExecuteChanged();
			}
		}

		RelayCommand? _processOneSelected;

		public RelayCommand ProcessOneSelectedCommand => _processOneSelected ??= new RelayCommand(ProcessOneSelected, CanProcessOneSelected);

		void ProcessOneSelected()
		{
			Debug.WriteLine(_selectedItem != null
				? $"Processed {_selectedItem.Name}"
				: "Attempting to process null item.");
		}

		bool CanProcessOneSelected()
		{
			return _selectedItem is not null;
		}

		RelayCommand<IList>? _processMultipleSelected;

		public RelayCommand<IList> ProcessMultipleSelectedCommand => _processMultipleSelected ??= new RelayCommand<IList>(ProcessMultipleSelected, CanProcessMultipleSelected);

		void ProcessMultipleSelected(IList? items)
		{
			if (items is null)
			{
				Debug.WriteLine("Attempted to process null collection.");
				return;
			}
			foreach (var gridDataItem in items.OfType<GridDataItem>())
			{
				Debug.WriteLine($"Processed {gridDataItem.Name}");
			}
		}

		bool CanProcessMultipleSelected(IList? items)
		{
			return items is not null && items.Count > 0;
		}
    }
}
