/* mbed Microcontroller Library
 * Copyright (c) 2020 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef PRIVACY_TEST_APP_GATTSERVERCALLBACKEVENTHANDLER_H
#define PRIVACY_TEST_APP_GATTSERVERCALLBACKEVENTHANDLER_H

#include "ble/GattServer.h"
#include "platform/Callback.h"

template<typename... Args>
struct CallbackChainEventHandler {
    void* add(mbed::Callback<void(Args...)> callback) {
        auto cb = new (std::nothrow) node_t { callback, nullptr };
        if (!cb) { return nullptr; }
        if (!head) {
            head = cb;
        } else {
            auto* it = head;
            while (it->next) {
                it = it->next;
            }
            it->next = cb;
        }
        return cb;
    }

    void remove_callback(void *node) {
        node_t* to_remove = reinterpret_cast<node_t*>(node);
        if (head == to_remove) {
            head = head->next;
        } else {
            auto* it = head;
            while (it->next) {
                if (it->next == to_remove) {
                    break;
                }
            }
            if (it->next) {
                it->next = to_remove->next;
            } else {
                to_remove = nullptr;
            }
        }

        delete to_remove;
    }

    void operator()(const Args&... args) {
        auto it = head;
        while (it) {
            it->callback(args...);
        }
    }

private:
    struct node_t {
        mbed::Callback<void(Args...)> callback;
        node_t* next = nullptr;
    };

    node_t *head;
};


struct GattServerCallbackEventHandler : private GattServer::EventHandler {

    CallbackChainEventHandler<ble::connection_handle_t, uint16_t> attMtuChange;

private:

    // GattServer::EventHandler implementation
    void onAttMtuChange(
        ble::connection_handle_t connectionHandle,
        uint16_t attMtuSize
    ) override {
        attMtuChange(connectionHandle, attMtuSize);
    }
};


#endif //PRIVACY_TEST_APP_GATTSERVERCALLBACKEVENTHANDLER_H
